package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.List;

/**
 * 手投预估数据查询
 *
 * @author zhangzhenghe
 * @since 2020-04-10 5:34 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ManualSlotDailyDataPageDTO extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -460545387173468600L;

    /**
     * 开始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    /**
     * 结束日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 账号ID
     */
    private Long mediaId;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 媒体ID列表
     */
    private List<Long> appIds;

    /**
     * 广告位ID列表
     */
    private List<Long> slotIds;
}
