package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author zhangliwei
 * @Description  预付款抵扣记录对象
 * @Date 19:05 2020-04-13
 * @Param
 * @return
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PreSettleDeductRecordDto extends BaseDto {
    
    @ApiModelProperty(value = "预付款结算订单", required = false)
    private Long                preSettleOrderId;

    @ApiModelProperty(value = "预付款订单号", required = false)
    private Long                prePayOrderId;

    @ApiModelProperty(value = "预付款本次抵消金额", required = false)
    private Long                amount;

    @ApiModelProperty(value = "预付款单总金额", required = false)
    private Long                prePayAmount;

    @ApiModelProperty(value = "预付款欠款金额", required = false)
    private Long                remainAmount;

    @ApiModelProperty(value = "当前主体预付款单金额", required = false)
    private Long                companyAmount;

    @ApiModelProperty(value = "0：杭州 1：霍尔果斯 2：霍城兑捷" , required = false)
    private Integer           companyType;

}
