package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/6/2
 * @Description
 * @Param
 * @return
 **/
@Data
public class ReqNoticeMediaDTO extends ReqPageQuery{
    /**
     * 主键列表
     */
    private List<Long> idList;
    /**
     * tb_notice 表主键列表
     */
    private List<Long> noticeIdList;

    /**
     * 主键
     */
    private Long id;
    /**
     * 媒体id|adminId
     * 传入的是媒体id时-需要传入platformId=1
     * 传入的是adminId时-需要传入platformId=2
     */
    private Long mediaId;

    /**
     * 通知id
     */
    private Long noticeId;

    /**
     * 读取状态（0：接收未读，1：接收已读）
     */
    private Integer readStatus;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 删除状态（0：未删除，1：已删除）
     */
    private Integer isDelete;
    /**
     * 消息类型:1-媒体线通知;2-火眼数据通知;3-广告线通知;4-实验平台通知;5-分控通知;6-其他
     * @see cn.com.duiba.tuia.ssp.center.api.constant.NoticeMessageTypeEnum
     */
    private Integer messageType;
    /**
     * 平台:1-媒体后台;2-媒体管理后台
     * @see cn.com.duiba.tuia.ssp.center.api.constant.NoticePlatformEnum
     */
    private Integer platform;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
}
