package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.AdvertInSlotsShieldStatusDto;
import cn.com.duiba.tuia.ssp.center.api.params.advertselect.AdvertInSlotsShieldStatusQuery;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.*;

import java.util.List;
import java.util.Set;

/**
 * 〈一句话功能简述〉<br>
 * Description: 提供给广告端的远程服务接口
 *
 * @author hillchen
 * @create 2018/10/18 下午5:06
 */
@AdvancedFeignClient
public interface RemoteAdvertSelectV2Service {
    /**
     * 上报广告行业标签变更
     * @param advertTagChangeReq
     * @return
     */
    boolean reportAdvertTagChange(AdvertTagChangeReq advertTagChangeReq);

    /**
     * 上报广告删除
     * @param advertIds
     * @return
     */
    boolean reportAdvertDelete(List<Long> advertIds);

    /**
     * 上报新增广告
     * @param advertBaseReq
     * @return
     */
    boolean reportNewAdvert(AdvertBaseReq advertBaseReq);

    /**
     * 上报广告素材变更
     * 接口更新 : 素材变更更新素材选中/素材审核,不影响广告选中策略
     * @param advertMaterialBaseReq
     * @return
     */
    boolean reportAdvertMaterialChange(AdvertMaterialBaseReq advertMaterialBaseReq);

    /**
     * @Author zhangliwei
     * @Description  上报广告通过逻辑
     * @Date 22:46 2019-07-25
     * @Param [advertPassReq]
     * @return boolean
     **/
    boolean reportAdvertPass(AdvertPassReq advertPassReq);

    /**
     * @Author zhangliwei
     * @Description  上报素材标签更改
     * @Date 16:14 2019-06-27
     * @Param [materialTagChangeReq]
     * @return boolean
     **/
    boolean reportMaterialTagChange(MaterialTagChangeReq materialTagChangeReq);

    /**
     * @Author zhangliwei
     * @Description  上报素材删除
     * @Date 16:14 2019-06-27
     * @Param [materialIds]
     * @return boolean
     **/
    boolean reportMaterialDelete(List<Long> materialIds);

    /**
     * @Author zhangliwei
     * @Description  6.25 更新 获取指定广告位下的广告位配置(包括选中广告行业标签、选中广告id集合、选中广告下素材ID集合)
     * @Date 16:00 2019-06-25
     * @Param [slotId]
     * @return cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.AdvertAndTagSelectedRsp
     **/
    AdvertAndTagSelectedRsp getSlotConfig(Long slotId);


    AdvertAndTagSelected4AdRsp getSlotConfig4Ad(Long slotId);

    boolean checkAdvertVisibleByShield(AdvertBaseReq advertBaseReq,Long mediaId);

    boolean checkAdvertVisible(AdvertBaseReq advertBaseReq,Long mediaId);

    /**
     * @Author zhangliwei
     * @Description  筛选目标广告位集合中,对当前广告可见的集合
     * @Date 20:37 2019-07-04
     * @Param [param]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.advertselect.AdvertInSlotsShieldStatusDto>
     **/
    List<AdvertInSlotsShieldStatusDto> queryAdvertInSlotsShieldStatus(AdvertInSlotsShieldStatusQuery param);

    /**
     * @Author zhangliwei
     * @Description  初始化数据
     * @Date 12:05 2019-07-20
     * @Param []
     * @return boolean
     **/
    boolean initData();

    /**
     * @Author zhangliwei
     * @Description  初始化可见标签
     * @Date 12:05 2019-07-20
     * @Param []
     * @return boolean
     **/
    boolean initVisibleTags();

    /**
     * @Author zhangliwei
     * @Description  初始化删除所有素材的审核记录和选中记录
     * @Date 21:00 2019-07-21
     * @Param []
     * @return boolean
     **/
    boolean testClearAllMaterial();

    /**
     * @Author zhangliwei
     * @Description  测试获取所有广告端素材标签
     * @Date 11:30 2019-07-22
     * @Param []
     * @return java.util.Set<java.lang.String>
     **/
    Set<String> testGetAllMaterialTags();

    /**
     * @Author zhangliwei
     * @Description  根据指定广告位ID集合刷新广告位缓存
     * @Date 15:32 2019-10-09
     * @Param [slotIds]
     * @return void
     **/
    void refreshCache(List<Long> slotIds);

    /**
     * @Author zhangliwei
     * @Description  测试发送刷新互选缓存方法
     * @Date 16:03 2019-10-09
     * @Param [slotIds]
     * @return boolean
     **/
    boolean testSendMessage(List<Long> slotIds);


    /**
     * @Author zhangliwei
     * @Description  将素材下包装形式的标签同步到落地页的包装形式中
     * @Date 17:08 2019-09-27
     * @Param []
     * @return boolean
     **/
    boolean initSyncPages();

}