package cn.com.duiba.tuia.ssp.center.api.remote.mobile;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.mobile.SmartCodeInfoDTO;

import java.util.List;

/**
 * 移动智码对接访问信息remote服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteSmartCodeInfoService {

    /**
     * SDK对接单次访问信息存储
     * @param smartCodeInfoDTO
     * @return
     */
    Boolean saveSmartCodeInfo(SmartCodeInfoDTO smartCodeInfoDTO);
    /**
     * SDK对接单次访问信息批量存储
     * @param smartCodeInfoDTOS
     * @return
     */
    Boolean batchSaveSmartCodeInfo(List<SmartCodeInfoDTO> smartCodeInfoDTOS);

    /**
     * 根据deviceId获取移动智码获取的UAID及物料等信息
     * @param deviceId
     * @return
     */
    List<SmartCodeInfoDTO> listSmartCodeInfo(String deviceId);
}
