package cn.com.duiba.tuia.ssp.center.api.remote.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;

import java.text.ParseException;

/**
 * 日账单数据作业业务处理服务
 *
 * @author ikongyi
 */
@AdvancedFeignClient
public interface RemoteAccountReportDayTaskService {

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="30000")
    Result<Boolean> execute(String request) throws BizException;

    /**
     * 测试用
     */
    Integer delete(String occurDate) throws ParseException;

}
