package cn.com.duiba.tuia.subscribe.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * Created by hong
 * time 2024/3/17.
 */
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
public class BasicSendCodeDto extends BasicHttpDto implements Serializable {
    /**
     * 发短信响应码
     */
    private String sendCodeErrorMsg;

    /**
     * 发短信响应码描述
     */
    private String sendCodeErrorCode;

    @Builder(toBuilder = true)
    public BasicSendCodeDto(String reqStr,
                            String reqHeader,
                            String resStr,
                            String reqUrl,
                            Integer advertCode,
                            String sendCodeErrorMsg,
                            String sendCodeErrorCode) {
        super(reqStr, reqHeader, resStr, reqUrl, advertCode);
        this.sendCodeErrorMsg = sendCodeErrorMsg;
        this.sendCodeErrorCode = sendCodeErrorCode;
    }
}
