package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/4/9.
 */
@Getter
public enum OrderExportEnum {

    phone(1, "phone", "下单号码"),
    orderTime(2, "orderTime", "下单时间"),
    orderCode(3, "orderCode", "下单验证码"),
    orderChannel(4, "orderChannel", "下单渠道"),
    tuiaOrderId(5, "tuiaOrderId", "推啊订单ID"),
    productId(6, "productId", "商品ID"),
    productName(7, "productName", "商品名称"),
    productPrice(8, "productPrice", "商品参考资费"),
    codeSendStatus(9, "codeSendStatus", "验证码发送状态"),
    codeSendFailReason(10, "codeSendFailReason", "验证码发送失败原因"),
    orderStatus(11, "orderStatus", "订单状态"),
    orderFailReason(12, "orderFailReason", "下单失败原因"),
    tuiaOrderStatus(13, "tuiaOrderStatus", "推啊订单状态"),
    estimateIncome(14, "estimateIncome", "预估收益"),
    pageId(15, "pageId", "积木id"),
    createTime(16, "createTime", "创建时间"),
    ;

    private final Integer code;
    private final String  type;
    private final String  desc;

    OrderExportEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static OrderExportEnum getByCode(Integer code) {
        return Stream.of(OrderExportEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(phone);
    }

    public static OrderExportEnum getByType(String type) {
        return Stream.of(OrderExportEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(phone);
    }
}
