package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/1/2.
 */
@Getter
public enum OperatorProductEnum {

    YIPAY(1, "yiPay", "翼支付",0),
    NANSHAN(2, "nanShan", "南山",0),
    GUANGDIAN(3, "guangDian", "广电",0),
    CHINAMOBILE(4, "chinamobile", "上海移动",0),
    GOLDDIGGERS(5, "goldDiggers", "挖金客",0),
    ZHONGLIAN(6, "zhongLian", "众联",0),
    POINTERA(7,"pointEra", "积分时代",0),
    ZJMOBILE(8, "zjMobile", "浙江移动",0),
    BEE_HELPER(9, "beeHelper", "蜂助手",0),
    CALL_SHOW(10, "callShow", "彩讯",0),
    IFLYTEK(11, "iflytek", "科大讯飞",0),
    EJCOP(12, "EJCOP", "易尊联通电信",0),
    EJCOPCM(13, "EJCOPCM", "易尊移动",0),
    HUIJICARD(14, "HUIJICARD", "会籍卡",1),;

    private final Integer code;
    private final String type;
    private final Integer businessType;
    private final String desc;

    OperatorProductEnum(Integer code, String type, String desc,Integer businessType) {
        this.code = code;
        this.type = type;
        this.desc = desc;
        this.businessType = businessType;
    }

    public static OperatorProductEnum getByCode(Integer code) {
        return Stream.of(OperatorProductEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(YIPAY);
    }

    public static OperatorProductEnum getByType(String type) {
        return Stream.of(OperatorProductEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(YIPAY);
    }

    public static Boolean includeByCode(Integer code){
        return Stream.of(OperatorProductEnum.values()).anyMatch(e -> e.getCode().equals(code));
    }
}
