package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/4/9.
 */
@Getter
public enum OrderExportEnum {

    phone(1, "phone", "下单号码", true),
    orderTime(2, "orderTime", "下单时间", true),
    orderCode(3, "orderCode", "下单验证码", true),
    orderChannel(4, "orderChannel", "下单渠道", true),
    tuiaOrderId(5, "tuiaOrderId", "推啊订单ID", true),
    productId(6, "productId", "商品ID", true),
    productName(7, "productName", "商品名称", true),
    productPrice(8, "productPrice", "商品参考资费", true),
    codeSendStatus(9, "codeSendStatus", "验证码发送状态", true),
    codeSendFailReason(10, "codeSendFailReason", "验证码发送失败原因", true),
    orderStatus(11, "orderStatus", "订单状态", true),
    orderFailReason(12, "orderFailReason", "下单失败原因", true),
    tuiaOrderStatus(13, "tuiaOrderStatus", "推啊订单状态值", true),
    estimateIncome(14, "estimateIncome", "预估收益", true),
    pageId(15, "pageId", "积木id", true),
    createTime(16, "createTime", "创建时间", true),
    channel(17,"channel","渠道", false),
    tuiaOrderStatusDesc(18,"tuiaOrderStatusDesc","推啊订单状态", false),
    ;

    private final Integer code;
    private final String  type;
    private final String  desc;
    private final Boolean display;

    OrderExportEnum(Integer code, String type, String desc, Boolean display) {
        this.code = code;
        this.type = type;
        this.desc = desc;
        this.display = display;
    }

    public static OrderExportEnum getByCode(Integer code) {
        return Stream.of(OrderExportEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(phone);
    }

    public static OrderExportEnum getByType(String type) {
        return Stream.of(OrderExportEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(phone);
    }
}
