package cn.tuia.tuia.treasure.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.management.relation.Relation;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Create by yuanwei
 * at 2019/1/16 0016 下午 17:26
 */
@ApiModel("文章视频推荐dto")
public class ArticleRecommentDto implements Serializable {

    @ApiModelProperty(value = "唯一标示id")
    private Long id;
    @ApiModelProperty(value = "标题")
    private String title;
    @ApiModelProperty(value = "是否推荐 0-不推荐，1-推荐")
    private Integer isRecommend;
    @ApiModelProperty(value = "素材样式，0-无图，1-大图（文字在上）,2-左文右图，4-三图模式，5-左图右文，6-大图（文字在图），7-二图（文字在上）")
    private Integer materialType;
    @ApiModelProperty(value = "标签配置")
    private TagConfig tagConfig;
    @ApiModelProperty(value = "推荐理由")
    private ReasonConfig reasonConfig;
    @ApiModelProperty(value = "文章标签")
    private String articleTag;
    @ApiModelProperty(value = "相关推荐ids")
    private List<RelationArticle> relationArticle;
    @ApiModelProperty(value = "推荐时间")
    private RecommentDate recommentDate;

    public TagConfig getTagConfig() {
        return tagConfig;
    }

    public void setTagConfig(TagConfig tagConfig) {
        this.tagConfig = tagConfig;
    }

    public ReasonConfig getReasonConfig() {
        return reasonConfig;
    }

    public void setReasonConfig(ReasonConfig reasonConfig) {
        this.reasonConfig = reasonConfig;
    }

    public RecommentDate getRecommentDate() {
        return recommentDate;
    }

    public void setRecommentDate(RecommentDate recommentDate) {
        this.recommentDate = recommentDate;
    }

    public List<RelationArticle> getRelationArticle() {
        return relationArticle;
    }

    public void setRelationArticle(List<RelationArticle> relationArticle) {
        this.relationArticle = relationArticle;
    }

    @ApiModel(value = "相关推荐文章")
    public static class RelationArticle implements Serializable{
        @ApiModelProperty(value = "文章id")
        private Long id;
        @ApiModelProperty(value = "文章标题")
        private String title;

        public  RelationArticle(Long id, String title) {
            this.id = id;
            this.title = title;
        }

        public RelationArticle() {
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    @ApiModel(value = "推荐时间")
    public static class RecommentDate implements Serializable{
        @ApiModelProperty(value = "推荐时间方式，0-马上推荐，1-稍后推荐")
        private Integer dateType;
        @ApiModelProperty(value = "推荐时间")
//        @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
        private Date recommentDate;

        public RecommentDate(Integer dateType, Date recommentDate) {
            this.dateType = dateType;
            this.recommentDate = recommentDate;
        }

        public RecommentDate() {
        }

        public Integer getDateType() {
            return dateType;
        }

        public void setDateType(Integer dateType) {
            this.dateType = dateType;
        }

        public Date getRecommentDate() {
            return recommentDate;
        }

        public void setRecommentDate(Date recommentDate) {
            this.recommentDate = recommentDate;
        }
    }


    @ApiModel(value = "推荐理由")
    public static class ReasonConfig implements Serializable{
        @ApiModelProperty(value = "推荐理由选项")
        private List<String> reasonType;
        @ApiModelProperty(value = "其他推荐理由")
        private String otherReason;

        public ReasonConfig(List<String> reasonType, String otherReason) {
            this.reasonType = reasonType;
            this.otherReason = otherReason;
        }

        public ReasonConfig() {
        }

        public List<String> getReasonType() {
            return reasonType;
        }

        public void setReasonType(List<String> reasonType) {
            this.reasonType = reasonType;
        }

        public String getOtherReason() {
            return otherReason;
        }

        public void setOtherReason(String otherReason) {
            this.otherReason = otherReason;
        }
    }

    @ApiModel(value = "标签配置")
    public static class TagConfig implements Serializable{
        @ApiModelProperty(value = "运营标签文字")
        private String operationTag;
        @ApiModelProperty(value = "运营标签颜色")
        private String operationTagColor;

        public TagConfig(String operationTag, String operationTagColor) {
            this.operationTag = operationTag;
            this.operationTagColor = operationTagColor;
        }

        public TagConfig() {
        }

        public String getOperationTag() {
            return operationTag;
        }

        public void setOperationTag(String operationTag) {
            this.operationTag = operationTag;
        }

        public String getOperationTagColor() {
            return operationTagColor;
        }

        public void setOperationTagColor(String operationTagColor) {
            this.operationTagColor = operationTagColor;
        }
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }


    public String getArticleTag() {
        return articleTag;
    }

    public void setArticleTag(String articleTag) {
        this.articleTag = articleTag;
    }


}
