package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.ArticleAbTestDto;
import cn.tuia.tuia.treasure.center.api.dto.ArticleAbTestReq;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.VideoDto;
import cn.tuia.tuia.treasure.center.api.dto.req.RankReq;
import cn.tuia.tuia.treasure.center.api.dto.req.VideoListQueryReq;

import java.util.List;

/**
 * @author wsz
 * @date 2019/1/16 16:26
 */
@AdvancedFeignClient
public interface RemoteNewUserRecommendService {

    /**
     * 获取推荐文章列表
     * @return
     */
    PageQueryResultDto<ArticleAbTestDto> getArticleList(ArticleAbTestReq req, Integer offset, Integer max);
    /**
     * 新文章人工推荐排序 管理端
     */
    Boolean sortForArticle(List<RankReq> list);

    /**
     * 更新文章人工推荐状态 管理端
     * @param articleIds 文章id 列表
     * @param isNewRecommend 0：否  1是
     */
    Boolean updateNewRecommendStatusForArticle(List<Long> articleIds, Integer isNewRecommend);

    /**
     * 管理端查询视频列表
     * @return 视频详情
     */
    PageQueryResultDto<VideoDto> getVideoList(VideoListQueryReq req);

    /**
     * 新文章人工推荐排序 管理端
     */
    Boolean sortForVideo(List<RankReq> list);

    /**
     * 更新视频人工推荐状态 管理端
     * @param videoIds 视频id 列表
     * @param isNewRecommend 0：否  1是
     */
    Boolean updateNewRecommendStatusForVideo(List<Long> videoIds, Integer isNewRecommend);
}
