package cn.tuia.tuia.treasure.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.tuia.treasure.center.api.dto.PageQueryResultDto;
import cn.tuia.tuia.treasure.center.api.dto.VideoDto;
import cn.tuia.tuia.treasure.center.api.dto.req.RecommendVideoReq;
import cn.tuia.tuia.treasure.center.api.dto.req.VideoListQueryReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVideoService {

    /**
     * @return 视频详表
     */
    List<VideoDto> getRecommendVideo(RecommendVideoReq req);

    /**
     * 获取置顶的视频
     */
    List<VideoDto> getTopVideo(RecommendVideoReq req);

    /**
     * @return 新用户视频详表
     */
    List<VideoDto> getNewUserRecommendVideo(RecommendVideoReq req);

    /**
     * 获得视频本身的相关推荐
     * @param req
     * @return
     */
    List<VideoDto> getVideoSelfRecommendVideo(RecommendVideoReq req);


    /**
     * 获取趣头条的推荐视频列表
     * @param req
     * @return
     */
    List<VideoDto> getquToutiaoRecommendVideo(RecommendVideoReq req);


    /**
     * 视频点赞
     * @param id 视频id
     * @return
     */
    Boolean updateLikesCount(Long userId,Long id);

    /**
     * 获取视频详情
     * @param videoId 视频id
     * @return 视频详情
     */
    VideoDto getVideoDetail(Long videoId);

    /**
     * 随机获取视频列表
     * @return 视频详情
     */
    List<VideoDto> getRandomVideoList(Integer count);

    /**
     * 管理端查询视频列表
     * @return 视频详情
     */
    PageQueryResultDto<VideoDto> getVideoList(VideoListQueryReq req);

    /**
     * 新增视频
     * @param dto
     * @return
     */
    int addVideo(VideoDto dto);

    /**
     * 下架视频
     * @param id 视频id
     * @return
     */
    int offVideo(Long id);


    int update(VideoDto dto);

    /**
     * 修改视频推荐配置
     * @return
     */
    Boolean updateRecommentConfig(VideoDto dto);

    /**
     * 查询视频推荐配置
     * @param id 视频id
     * @return
     */
    VideoDto queryRecommentConfig(Long id);

    /**
     * 通过推荐标签获取相关的视频
     * @param tag 推荐标
     * @return
     */
    List<VideoDto> queryRelaionVideos(String tag);

    /**
     * 修改是否置顶
     * @param isStick 是否置顶
     * @param id 视频id
     * @return
     */
    Boolean updateIsStick(Integer isStick, Long id);


}
