package cn.com.duiba.tuia.youtui.center.api.constant;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 用户标签枚举
 */
public enum UserTagType {
    USER_AGE(0, "选择最接近的年龄段，为您推荐更合适的内容", Lists.newArrayList(new Option(Lists.newArrayList("https://yun.playpangu.com/qushai/70@2x.webp"),"我是70后","70",0),new Option(Lists.newArrayList("https://yun.playpangu.com/qushai/80@2x.webp"),"我是80后","80",0),new Option(Lists.newArrayList("http://yun.playpangu.com/qushai/90@2x.webp"),"我是90后","90",0)));

    private Integer tagType;
    private String desc;
    private List<Option> options;

    UserTagType(Integer tagType, String desc, List<Option> options) {
        this.tagType = tagType;
        this.desc = desc;
        this.options = options;
    }

    public List<Option> getOptions() {
        return options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public Integer getTagType() {
        return tagType;
    }

    public void setTagType(Integer tagType) {
        this.tagType = tagType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @ApiModel("标签选项，2.3.3版本新增")
    public static class Option {

        @ApiModelProperty(value = "图片列表", dataType = "String")
        private List<String> imgs;

        @ApiModelProperty(value = "选项标题", dataType = "String")
        private String title;

        @ApiModelProperty(value = "选项值", dataType = "String")
        private String value;

        @ApiModelProperty(value = "标签类型", dataType = "int")
        private int type;


        public Option() {
        }

        public Option(List<String> imgs, String title, String value, int type) {
            this.imgs = imgs;
            this.title = title;
            this.value = value;
            this.type = type;
        }

        public List<String> getImgs() {
            return imgs;
        }

        public void setImgs(List<String> imgs) {
            this.imgs = imgs;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
