package cn.com.duiba.tuia.youtui.center.api.dto.game;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.RuleConfigDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 挤肥皂游戏配置dto
 */
@ApiModel("挤肥皂游戏配置")
public class DistributionDto extends RuleConfigDto implements Serializable {
    /**
     * 难度配置
     */
    @ApiModelProperty(value = "难度配置", dataType = "List<DifficultyConfig>")
    private List<DifficultyConfig> difficultyConfigList;

    /**
     * 道具规则 0 概率出现 1 固定关卡
     */
    @ApiModelProperty(value = "道具规则", dataType = "Integer")
    private Integer propsRule;

    /**
     * 当为概率出现时，此字段生效，目前默认为100
     */
    @ApiModelProperty(value = "当为概率出现时，此字段生效", dataType = "Integer")
    private Integer propProbability;

    /**
     * 当为概率出现时，此字段生效，目前默认为1
     */
    @ApiModelProperty(value = "当为概率出现时，此字段生效", dataType = "Integer")
    private Integer propLimit;

    /**
     * 当为固定关卡时次字段生效,关卡Id集合
     */
    @ApiModelProperty(value = "当为固定关卡时次字段生效,关卡Id集合", dataType = "String")
    private String checkpointId;

    /**
     * 是否启用福袋 0关闭 1开启
     */
    @ApiModelProperty(value = "是否启用福袋", dataType = "int")
    private int luckyBag;

    public List<DifficultyConfig> getDifficultyConfigList() {
        return difficultyConfigList;
    }

    public void setDifficultyConfigList(List<DifficultyConfig> difficultyConfigList) {
        this.difficultyConfigList = difficultyConfigList;
    }

    public Integer getPropsRule() {
        return propsRule;
    }

    public void setPropsRule(Integer propsRule) {
        this.propsRule = propsRule;
    }

    public Integer getPropProbability() {
        return propProbability;
    }

    public void setPropProbability(Integer propProbability) {
        this.propProbability = propProbability;
    }

    public Integer getPropLimit() {
        return propLimit;
    }

    public void setPropLimit(Integer propLimit) {
        this.propLimit = propLimit;
    }

    public String getCheckpointId() {
        return checkpointId;
    }

    public void setCheckpointId(String checkpointId) {
        this.checkpointId = checkpointId;
    }

    public int getLuckyBag() {
        return luckyBag;
    }

    public void setLuckyBag(int luckyBag) {
        this.luckyBag = luckyBag;
    }

    public static class DifficultyConfig implements Serializable {

        private static final long serialVersionUID = 4726662262765482250L;

        /**
         * 唯一标识id关卡
         */
        @ApiModelProperty(value = "唯一标识id关卡", dataType = "Integer")
        private Integer id;
        /**
         * 红色区域占比
         */
        private Integer redArea;
        /**
         * 橙色区域占比
         */
        private Integer orangeArea;
        /**
         * 绿色区域占比
         */
        private Integer greenArea;

        /**
         * 是否移动
         */
        private boolean isMove;

        /**
         * 移动速度
         */
        private Integer moveSpeed;

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public boolean isMove() {
            return isMove;
        }

        public void setMove(boolean move) {
            isMove = move;
        }

        public Integer getRedArea() {
            return redArea;
        }

        public void setRedArea(Integer redArea) {
            this.redArea = redArea;
        }

        public Integer getOrangeArea() {
            return orangeArea;
        }

        public void setOrangeArea(Integer orangeArea) {
            this.orangeArea = orangeArea;
        }

        public Integer getGreenArea() {
            return greenArea;
        }

        public void setGreenArea(Integer greenArea) {
            this.greenArea = greenArea;
        }

        public boolean getIsMove() {
            return isMove;
        }

        public void setIsMove(boolean isMove) {
            this.isMove = isMove;
        }

        public Integer getMoveSpeed() {
            return moveSpeed;
        }

        public void setMoveSpeed(Integer moveSpeed) {
            this.moveSpeed = moveSpeed;
        }
    }
}
