package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 签到dto
 */
public class YoutuiSignCountDto extends BaseDto {

    private Long consumerId;

    private Long signTimestamp;

    private Integer signTimes;

    //是否首次签到（0：非首次；1：首次）
    private int isFirst;

    //今日签到状态,0：未签；1：已签
    private Integer todaySignStatus;

    public Integer getTodaySignStatus() {
        return todaySignStatus;
    }

    public void setTodaySignStatus(Integer todaySignStatus) {
        this.todaySignStatus = todaySignStatus;
    }

    public int getIsFirst() {
        return isFirst;
    }

    public void setIsFirst(int isFirst) {
        this.isFirst = isFirst;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getSignTimestamp() {
        return signTimestamp;
    }

    public void setSignTimestamp(Long signTimestamp) {
        this.signTimestamp = signTimestamp;
    }

    public Integer getSignTimes() {
        return signTimes;
    }

    public void setSignTimes(Integer signTimes) {
        this.signTimes = signTimes;
    }


    @ApiModel("用户签到结果类")
    public static class SignResult {
        @ApiModelProperty("奖励类型，0：金币；1：红包")
        private Integer rewardType;

        @ApiModelProperty("奖励金额，金币（个）；红包（分）")
        private Long amount;

        public Integer getRewardType() {
            return rewardType;
        }

        public void setRewardType(Integer rewardType) {
            this.rewardType = rewardType;
        }

        public Long getAmount() {
            return amount;
        }

        public void setAmount(Long amount) {
            this.amount = amount;
        }
    }

    @ApiModel("用户签到每日配置")
    public static class SignDayConf {

        @ApiModelProperty("签到天数")
        private Integer dayNum;

        @ApiModelProperty("奖励类型，0：金币；1：红包")
        private Integer rewardType;

        @ApiModelProperty("签到规则配置，当rewardType为1时有值：1，2，3")
        private Integer redBagLev;

        @ApiModelProperty("最高奖励金额，金币（个）；红包（分）")
        private Long amount;

        @ApiModelProperty("实际奖励金额，金币（个）；红包（分）")
        private Long rewardAmount;

        @ApiModelProperty("实际奖励金额文案")
        private String text;

        public SignDayConf() {
        }

        public SignDayConf(Integer dayNum, Integer rewardType, Integer redBagLev, Long amount, Long rewardAmount,String text) {
            this.dayNum = dayNum;
            this.rewardType = rewardType;
            this.redBagLev = redBagLev;
            this.amount = amount;
            this.rewardAmount = rewardAmount;
            this.text = text;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Long getRewardAmount() {
            return rewardAmount;
        }

        public void setRewardAmount(Long rewardAmount) {
            this.rewardAmount = rewardAmount;
        }

        public Integer getDayNum() {
            return dayNum;
        }

        public void setDayNum(Integer dayNum) {
            this.dayNum = dayNum;
        }

        public Integer getRewardType() {
            return rewardType;
        }

        public void setRewardType(Integer rewardType) {
            this.rewardType = rewardType;
        }

        public Integer getRedBagLev() {
            return redBagLev;
        }

        public void setRedBagLev(Integer redBagLev) {
            this.redBagLev = redBagLev;
        }

        public Long getAmount() {
            return amount;
        }

        public void setAmount(Long amount) {
            this.amount = amount;
        }
    }


    /**
     * 已分享过用户签到配置
     * @return
     */
    public static List<SignDayConf> signRewardConfig4shared() {
        SignDayConf signDayConf0 = new SignDayConf(7, 1, 1, 600L, 15L,"最高6元");
        SignDayConf signDayConf1 = new SignDayConf(1, 0, 1, 20L, 20L,"20金币");
        SignDayConf signDayConf2 = new SignDayConf(2, 0, 1, 100L, 100L,"100金币");
        SignDayConf signDayConf3 = new SignDayConf(3, 1, 2, 200L, 20L,"最高2元");
        SignDayConf signDayConf4 = new SignDayConf(4, 0, 1, 50L, 50L,"50金币");
        SignDayConf signDayConf5 = new SignDayConf(5, 0, 1, 80L, 80L,"80金币");
        SignDayConf signDayConf6 = new SignDayConf(6, 0, 1, 100L, 100L,"100金币");
        return Lists.newArrayList(signDayConf0, signDayConf1, signDayConf2, signDayConf3, signDayConf4, signDayConf5, signDayConf6);
    }

    /**
     * 未分享过用户签到配置
     * @return
     */
    public static List<SignDayConf> signRewardConfig4notShared() {
        SignDayConf signDayConf0 = new SignDayConf(7, 1, 1, 600L, 15L,"最高6元");
        SignDayConf signDayConf1 = new SignDayConf(1, 1, 3, 50L, 50L,"0.5元");
        SignDayConf signDayConf2 = new SignDayConf(2, 0, 1, 100L, 100L,"100金币");
        SignDayConf signDayConf3 = new SignDayConf(3, 1, 2, 200L, 20L,"最高2元");
        SignDayConf signDayConf4 = new SignDayConf(4, 0, 1, 50L, 50L,"50金币");
        SignDayConf signDayConf5 = new SignDayConf(5, 0, 1, 80L, 80L,"80金币");
        SignDayConf signDayConf6 = new SignDayConf(6, 0, 1, 100L, 100L,"100金币");
        return Lists.newArrayList(signDayConf0, signDayConf1, signDayConf2, signDayConf3, signDayConf4, signDayConf5, signDayConf6);
    }
}
