package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import cn.com.duiba.tuia.youtui.center.api.util.SignTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.jsoup.Connection;
import org.jsoup.Jsoup;


import java.io.Serializable;
import java.util.Map;

@ApiModel("拼多多接口通用参数")
public abstract class PDDBaseReq implements Serializable {

    //private static final String DEFAULT_CLIENT_ID = "d6d52cf1d49f4585891a19ef244c03b9";
    //private static final String DEFAULT_CLIENT_SECRET = "cf4d9de20af1adbf92c5420ef83bdcb0581604a4";

    //麦全主题
    private static final String DEFAULT_CLIENT_ID = "b39437db92544f0196327cb76cb10e7b";
    private static final String DEFAULT_CLIENT_SECRET = "eeed113900268d47a21220b19b23656518ccc336";
    private static final String PDD_URL = "http://gw-api.pinduoduo.com/api/router";


    @ApiModelProperty(value = "POP分配给应用的client_id", required = true)
    private String clienId;

    @ApiModelProperty(value = "通过code获取的access_token(无需授权的接口，该字段不参与sign签名运算", required = false)
    private String accessToken;

    @ApiModelProperty(value = "UNIX时间戳", required = true)
    private String timestamp;

    @ApiModelProperty(value = "响应格式，即返回数据的格式，JSON或者XML（二选一），默认JSON，注意是大写", required = true)
    private String dataType;

    @ApiModelProperty(value = "API协议版本号，默认为V1，可不填", required = false)
    private String version;

    @ApiModelProperty(value = "API输入参数签名结果，签名算法参考开放平台接入指南第三部分底部。", required = true)
    private String sign;

    public PDDBaseReq() {
        this.clienId = DEFAULT_CLIENT_ID;
        this.version = "V1";
        this.timestamp = System.currentTimeMillis() + "";
        this.dataType = "JSON";
    }

    /**
     * 生成加密参数MAP
     *
     * @return
     */
    public Map<String, String> toMap() {
        Map<String, String> paramsMap = Maps.newTreeMap();
        paramsMap.put("type", this.getType());
        paramsMap.put("client_id", this.getClienId());
        paramsMap.put("timestamp", this.getTimestamp());
        paramsMap.put("data_type", this.getDataType());
        paramsMap.put("version", this.getVersion());
        return paramsMap;
    }

    /**
     * 请求参数签名
     *
     * @return
     */
    public Map<String, String> doSign() {
        Map<String, String> paramsMap = this.toMap();
        String sign = SignTool.sign4pdd(paramsMap, DEFAULT_CLIENT_SECRET);
        paramsMap.put("sign", sign);
        return paramsMap;
    }

    public JSONObject request() throws Exception {
        StringBuilder url = new StringBuilder(PDD_URL).append("?");
        this.doSign().forEach((k, v) -> {
            url.append(k).append("=").append(v).append("&");
        });
        String body = Jsoup.connect(url.toString()).timeout(3000).method(this.getRequestMethod()).ignoreContentType(true).execute().body();
        return JSON.parseObject(body);
    }

    public String getKey(){
        return "";
    }

    public Class getDtoClass(){
        return null;
    }

    public Object toDto(){
        try {
            Object dto = this.request().getJSONObject(getKey()).toJavaObject( this.getDtoClass());
            return dto;
        } catch (Exception e) {

        }
        return null;
    }

    public abstract String getType();

    public Connection.Method getRequestMethod() {
        return Connection.Method.POST;
    }

    public String getClienId() {
        return clienId;
    }

    public void setClienId(String clienId) {
        this.clienId = clienId;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}
