package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;


import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 拼多多商品类目Dto
 */
@ApiModel("拼多多商品类目Dto")
public class PDDGoodsCatDto extends BaseDto {

    @ApiModelProperty("类目级别")
    private Integer level;

    @ApiModelProperty("类目名称")
    private String catName;

    @ApiModelProperty("父类目ID，0时为顶级节点")
    private Long parentCatId;

    @ApiModelProperty("类目ID")
    private Long catId;

    @ApiModelProperty("是否上架，0-未上架，1-已上架")
    private Integer isPublish;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PDDGoodsCatDto that = (PDDGoodsCatDto) o;
        return Objects.equals(level, that.level) &&
                Objects.equals(catName, that.catName) &&
                Objects.equals(parentCatId, that.parentCatId) &&
                Objects.equals(catId, that.catId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(level, catName, parentCatId, catId);
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getCatName() {
        return catName;
    }

    public void setCatName(String catName) {
        this.catName = catName;
    }

    public Long getParentCatId() {
        return parentCatId;
    }

    public void setParentCatId(Long parentCatId) {
        this.parentCatId = parentCatId;
    }

    public Long getCatId() {
        return catId;
    }

    public void setCatId(Long catId) {
        this.catId = catId;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    /**
     * 将返回的JSON Object转换为class
     * @return
     */
    public static List<PDDGoodsCatDto> jsonObjectToClass(JSONObject jsonObject) {
        List<PDDGoodsCatDto> list = new ArrayList<>();
        JSONObject goodsCatsGetResponse = jsonObject.getJSONObject("goods_cats_get_response");
        JSONArray goodsCatsList = goodsCatsGetResponse.getJSONArray("goods_cats_list");
        for (Object goodsCat : goodsCatsList) {
            JSONObject goodsCatJSONObject = (JSONObject) goodsCat;
            Integer level = goodsCatJSONObject.getInteger("level");
            Long catId = goodsCatJSONObject.getLong("cat_id");
            Long parentCatId = goodsCatJSONObject.getLong("parent_cat_id");
            String catName = goodsCatJSONObject.getString("cat_name");
            PDDGoodsCatDto dto = new PDDGoodsCatDto();
            dto.setCatId(catId);
            dto.setLevel(level);
            dto.setParentCatId(parentCatId);
            dto.setCatName(catName);
            list.add(dto);
        }
        return list;
    }

    @ApiModel("类目请求参数")
    public static class PDDGoodsCatReq extends PDDBaseReq{

        @ApiModelProperty("父级类目ID")
        private Integer parent_cat_id;

        public PDDGoodsCatReq() {
            this.parent_cat_id = 0;
        }

        public PDDGoodsCatReq(Integer parent_cat_id) {
            this.parent_cat_id = parent_cat_id;
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("parent_cat_id",this.getParent_cat_id().toString());
            return paramsMap;
        }

        @Override
        public String getType() {
            return "pdd.goods.cats.get";
        }

        public Integer getParent_cat_id() {
            return parent_cat_id;
        }

        public void setParent_cat_id(Integer parent_cat_id) {
            this.parent_cat_id = parent_cat_id;
        }

    }

    public static void main(String[] args) throws Exception {
        PDDGoodsCatReq req = new PDDGoodsCatReq();
        System.out.println(req.request());
    }
}
