package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

@ApiModel("拼多多商品推广链接Dto")
public class PDDGoodsPromUrlDto {

    @ApiModelProperty("拼多多商品推广链接集合")
    private List<GoodsPromUrl> goods_promotion_url_list;

    public List<GoodsPromUrl> getGoods_promotion_url_list() {
        return goods_promotion_url_list;
    }

    public void setGoods_promotion_url_list(List<GoodsPromUrl> goods_promotion_url_list) {
        this.goods_promotion_url_list = goods_promotion_url_list;
    }

    @ApiModel("拼多多商品推广链接对象")
    public static class GoodsPromUrl {

        @ApiModelProperty("唤起微信app推广短链接")
        private String we_app_web_view_short_url;

        @ApiModelProperty("唤起微信app推广链接")
        private String we_app_web_view_url;

        @ApiModelProperty("唤醒拼多多app的推广短链接")
        private String mobile_short_url;

        @ApiModelProperty("唤醒拼多多app的推广长链接")
        private String mobile_url;

        @ApiModelProperty("推广短链接")
        private String short_url;

        @ApiModelProperty("推广长链接")
        private String url;

        public String getWe_app_web_view_short_url() {
            return we_app_web_view_short_url;
        }

        public void setWe_app_web_view_short_url(String we_app_web_view_short_url) {
            this.we_app_web_view_short_url = we_app_web_view_short_url;
        }

        public String getWe_app_web_view_url() {
            return we_app_web_view_url;
        }

        public void setWe_app_web_view_url(String we_app_web_view_url) {
            this.we_app_web_view_url = we_app_web_view_url;
        }

        public String getMobile_short_url() {
            return mobile_short_url;
        }

        public void setMobile_short_url(String mobile_short_url) {
            this.mobile_short_url = mobile_short_url;
        }

        public String getMobile_url() {
            return mobile_url;
        }

        public void setMobile_url(String mobile_url) {
            this.mobile_url = mobile_url;
        }

        public String getShort_url() {
            return short_url;
        }

        public void setShort_url(String short_url) {
            this.short_url = short_url;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static void main(String[] args) throws Exception {
        GoodsPromUrlReq goodsPromUrlReq =new GoodsPromUrlReq();
        goodsPromUrlReq.setGoodsIds(Lists.newArrayList(2881352613L));
        System.err.println(goodsPromUrlReq.request().toJSONString());
    }

    @ApiModel("拼多多商品推广链接Req")
    public static class GoodsPromUrlReq extends PDDBaseReq {

        @ApiModelProperty("商品ID，仅支持单个查询")
        private List<Long> goodsIds;

        @ApiModelProperty("是否生成短链接，true-是，false-否")
        private Boolean generateShortUrl = true;

        @ApiModelProperty("true--生成多人团推广链接 false--生成单人团推广链接（默认false）1、单人团推广链接：用户访问单人团推广链接，可直接购买商品无需拼团。2、多人团推广链接：用户访问双人团推广链接开团，若用户分享给他人参团，则开团者和参团者的佣金均结算给推手")
        private Boolean multiGroup = false;

        @ApiModelProperty("自定义参数，为链接打上自定义标签。自定义参数最长限制64个字节(2.3.0仅代表userId)")
        private String customParameters;

        @ApiModelProperty("是否开启订单拉新，true表示开启（订单拉新奖励特权仅支持白名单，请联系工作人员开通）")
        private Boolean pullNew = false;

        @ApiModelProperty("是否生成唤起微信客户端链接，true-是，false-否，默认false")
        private Boolean generateWeappWebview = true;

        @ApiModelProperty("招商多多客ID")
        private Long zsDuoId;

        public Boolean getGenerateShortUrl() {
            return generateShortUrl;
        }

        public void setGenerateShortUrl(Boolean generateShortUrl) {
            this.generateShortUrl = generateShortUrl;
        }

        public Boolean getMultiGroup() {
            return multiGroup;
        }

        public void setMultiGroup(Boolean multiGroup) {
            this.multiGroup = multiGroup;
        }

        public String getCustomParameters() {
            return customParameters;
        }

        public void setCustomParameters(String customParameters) {
            this.customParameters = customParameters;
        }

        public Boolean getPullNew() {
            return pullNew;
        }

        public void setPullNew(Boolean pullNew) {
            this.pullNew = pullNew;
        }

        public Boolean getGenerateWeappWebview() {
            return generateWeappWebview;
        }

        public void setGenerateWeappWebview(Boolean generateWeappWebview) {
            this.generateWeappWebview = generateWeappWebview;
        }

        public Long getZsDuoId() {
            return zsDuoId;
        }

        public void setZsDuoId(Long zsDuoId) {
            this.zsDuoId = zsDuoId;
        }

        public List<Long> getGoodsIds() {
            return goodsIds;
        }

        public void setGoodsIds(List<Long> goodsIds) {
            this.goodsIds = goodsIds;
        }

        @Override
        public String getType() {
            return "pdd.ddk.goods.promotion.url.generate";
        }

        /**
         * 生成加密参数MAP
         *
         * @return
         */
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("p_id", PDDConstant.PID);
            paramsMap.put("goods_id_list", JSON.toJSONString(this.getGoodsIds()));
            paramsMap.put("generate_short_url", this.getGenerateShortUrl().toString());
            paramsMap.put("multi_group", this.getMultiGroup().toString());
            paramsMap.put("custom_parameters", this.getCustomParameters());
            paramsMap.put("pull_new", this.getPullNew().toString());
            paramsMap.put("generate_weapp_webview", this.getGenerateWeappWebview().toString());
            if (null != this.getZsDuoId()) {
                paramsMap.put("zs_duo_id", this.getZsDuoId().toString());
            }
            return paramsMap;
        }

        public String getKey() {
            return "goods_promotion_url_generate_response";
        }

        public Class getDtoClass() {
            return PDDGoodsPromUrlDto.class;
        }

        public PDDGoodsPromUrlDto toDto() {
            try {
                Object dto = super.toDto();
                return (PDDGoodsPromUrlDto) dto;
            } catch (Exception e) {

            }
            return null;
        }
    }
}
