package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

public class PDDPidDto {

    private List<PidDto> p_id_list;


    public List<PidDto> getP_id_list() {
        return p_id_list;
    }

    public void setP_id_list(List<PidDto> p_id_list) {
        this.p_id_list = p_id_list;
    }

    public static void main(String[] args) throws Exception {
        PDDPidReq pddBaseReq = new PDDPidReq();
        pddBaseReq.setNumber(1);
        pddBaseReq.setP_id_name_list(Lists.newArrayList("趣晒-Android"));
        System.err.println(pddBaseReq.request().toJSONString());
    }

    public static class PDDPidReq extends PDDBaseReq {

        private Integer number;

        private List<String> p_id_name_list;

        /**
         * 生成加密参数MAP
         *
         * @return
         */
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("number", JSON.toJSONString(this.getNumber()));
            if (!CollectionUtils.isEmpty(this.getP_id_name_list())) {
                paramsMap.put("p_id_name_list", JSON.toJSONString(this.getP_id_name_list()));
            }
            return paramsMap;
        }

        public String getKey() {
            return "p_id_generate_response";
        }

        public Class getDtoClass() {
            return PDDPidDto.class;
        }

        public PDDPidDto toDto() {
            try {
                Object dto = super.toDto();
                return (PDDPidDto) dto;
            } catch (Exception e) {

            }
            return null;
        }

        public Integer getNumber() {
            return number;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }

        public List<String> getP_id_name_list() {
            return p_id_name_list;
        }

        public void setP_id_name_list(List<String> p_id_name_list) {
            this.p_id_name_list = p_id_name_list;
        }

        @Override
        public String getType() {
            return "pdd.ddk.goods.pid.generate";
        }
    }

    public static class PidDto {

        private String p_id_name;

        private String p_id;

        public String getP_id_name() {
            return p_id_name;
        }

        public void setP_id_name(String p_id_name) {
            this.p_id_name = p_id_name;
        }

        public String getP_id() {
            return p_id;
        }

        public void setP_id(String p_id) {
            this.p_id = p_id;
        }
    }
}
