package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

/**
 * 拼多多商品查询范围参数
 * 范围列表，可选值：[{"range_id":0,"range_from":1,"range_to":1500},{"range_id":1,"range_from":1,"range_to":1500}]
 */
public class PDDRangeParam {

    /**
     * 如果左区间不限制，range_from传空就行，右区间不限制，range_to传空就行
     */
    private Integer range_to;

    /**
     * 如果左区间不限制，range_from传空就行，右区间不限制，range_to传空就行
     */
    private Integer range_from;

    /**
     * 查询维度ID，枚举值如下：
     * 0-商品拼团价格区间，
     * 1-商品券后价价格区间，
     * 2-佣金比例区间，
     * 3-优惠券金额区间，
     * 4-加入多多进宝时间区间，
     * 5-销量区间，
     * 6-佣金金额区间，
     * 7-店铺描述评分区间，
     * 8-店铺物流评分区间，
     * 9-店铺服务评分区间
     */
    private Integer range_id;

    public Integer getRange_to() {
        return range_to;
    }

    public void setRange_to(Integer range_to) {
        this.range_to = range_to;
    }

    public Integer getRange_from() {
        return range_from;
    }

    public void setRange_from(Integer range_from) {
        this.range_from = range_from;
    }

    public Integer getRange_id() {
        return range_id;
    }

    public void setRange_id(Integer range_id) {
        this.range_id = range_id;
    }
}
