package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqRewardFactor;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.RewardFactorDto;

import java.util.List;

/**
 * author: 胡 朋
 * github: https://github.com/xiaomoinfo
 * email : xiaomo@xiaomo.info
 * QQ    : 83387856
 * Date  : 2018/7/10 11:19
 * desc  :
 */
@AdvancedFeignClient
public interface RemoteRewardFactorService {

    /**
     * 查询分享奖励系数列表
     *
     * @param req
     * @return
     */
    List<RewardFactorDto> queryList(ReqRewardFactor req);


    /**
     * 新增分享奖励系数
     *
     * @param param
     * @return
     */
    Integer addRewardFactor(RewardFactorDto param);

    /**
     * 查询奖励系数
     * <p>
     * 提供给管理端使用的接口
     *
     * @param curDate
     * @return
     */
    RewardFactorDto queryRewardFactor(String curDate);

    /**
     * 修改奖励系数
     *
     * @param param
     * @return
     */
    Integer updateRewardFactor(RewardFactorDto param);

    /**
     * 查询日期最近的奖励系数
     * <p>
     * 提供给有推的接口
     *
     * @param curDate
     * @return
     */
    RewardFactorDto queryRecentRewardFactor(String curDate);
}
