package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.tag.UserTagDto;

/**
 * 用户标签接口
 */
@AdvancedFeignClient
public interface RemoteUserTagService {
    /**
     * 根据用户和标签类型查询标签值
     *
     * @param userId
     * @param tagType
     * @return
     */
    public UserTagDto selectByUserAndType(Long userId, Integer tagType);

    /**
     * 插入用户标签选择
     *
     * @param userId
     * @param tagType
     * @param tagValue
     * @return
     */
    public int insertTag(Long userId, Integer tagType, String tagValue);
}
