package cn.com.duiba.tuia.youtui.center.api.util;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.*;

/**
 * 签名工具
 */
public class SignTool {

    /**
     * 验签方法
     *
     * @param params
     * @return
     */
    public static boolean signVerify(String appSecret, Map<String, String> params) {
        String sign = sign(appSecret, params);
        if (sign.equals(params.get("sign"))) {
            return true;
        }
        return false;
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null)
            return "";
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * 签名方法
     *
     * @param params
     * @return
     */
    public static String sign(String appSecret, Map<String, String> params) {
        Map<String, String> map = new TreeMap<>();
        map.put("appSecret", appSecret);
        for (String key : params.keySet()) {
            if (!key.equals("sign")) {
                map.put(key, params.get(key));
            }
        }
        String sign = sign(map);
        return sign;
    }

    /**
     * 签名方法
     *
     * @param params
     * @return
     */
    public static String sign(Map<String, String> params) {
        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            string += params.get(s);
        }
        String sign = "";
        try {
            sign = toHexValue(encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("sign md5 error");
        }
        return sign;
    }

    /**
     * 拼多多签名算法
     *
     * @param params
     * @param clientSecret
     * @return
     */
    public static String sign4pdd(Map<String, String> params, String clientSecret) {
        params.remove("clientSecret");
        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = clientSecret;
        for (String s : keys) {
            string += (s + params.get(s));
        }
        string += clientSecret;
        String sign = "";
        try {
            byte[] bytes = DigestUtils.md5(string);
            sign = new String(Hex.encodeHex(bytes, false));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("sign4pdd md5 error");
        }
        return sign;
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static void main(String[] args) {
        String appKey = "key";
        String appSecret = "secret";

        Map<String, String> params = new TreeMap<String, String>();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", new Date().getTime() + "");

        String sign = sign(params);

        params.put("sign", sign);

        System.out.println(signVerify(appSecret, params));

        Map<String, String> params4pdd = new TreeMap<String, String>();
        params4pdd.put("access_token", "asd78172s8ds9a921j9qqwda12312w1w21211");
        params4pdd.put("client_id", "1");
        params4pdd.put("data_type", "XML");
        params4pdd.put("order_status", "1");
        params4pdd.put("page", "1");
        params4pdd.put("page_size", "10");
        params4pdd.put("timestamp", "1480411125");
        params4pdd.put("type", "pdd.order.number.list.get");
        System.err.println(sign4pdd(params4pdd, "testSecret"));

    }
}
