package cn.com.duiba.tuia.union.star.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.common.page.TableDataInfo;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.MobileUaInfoDTO;
import java.util.List;

/**
 * 设备ua解析Service
 * @Author: xingbo
 * @Date: 2021/6/1 2:43
 */
@AdvancedFeignClient
public interface RemoteDeviceUaParseService {
    /**
     * 查询品牌列表
     */
    TableDataInfo deviceUaList(MobileUaInfoDTO MobileUaInfoDTO, Integer pageNum, Integer pageSize);

    /**
     * 保存ua解析得到的设备信息
     * @param MobileUaInfoDTO
     * @return
     */
    int saveDeviceUaInfo(MobileUaInfoDTO MobileUaInfoDTO);

    /**
     * 手动更新设备信息
     */
    int updateDeviceInfo(MobileUaInfoDTO MobileUaInfoDTO);

    /**
     * 删除设备信息（物理删除）
     */
    int deleteDeviceInfo(Long id);

    /**
     * 批量删除设备信息（物理删除）
     */
    int deleteDeviceInfos(Long[] ids);

    /**
     * 根据id查找设备
     */
    MobileUaInfoDTO selectMobileUaInfoById(Long id);

    /**
     * 根据设备型号查找设备
     */
    MobileUaInfoDTO selectMobileUaInfoByPhoneModel(String phoneModel);

    /**
     * 返回需要更新PV的设备型号
     */
    List<String> selectMobileNameByPv();

    /**
     * 根据设备型号查找UA解析信息
     * @param phoneModel
     * @return
     */
    MobileUaInfoDTO selectUaParseInfoByPhoneModel(String phoneModel);

    /**
     * 删除指定日期范围内的pv记录
     */
    Integer deleteMobileUaPvByDate(String startDate, String endDate);
}
