package cn.com.duiba.tuia.union.star.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.union.star.center.api.RemoteIdCardNameServiceFallback;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.req.IdCardNameReq;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.result.IdCardNameResult;

/**
 * @author Wangpf
 * @description
 * @date 2021/4/26 11:19 上午
 */
@AdvancedFeignClient(fallback = RemoteIdCardNameServiceFallback.class)
public interface RemoteIdCardNameService {

    /**
     * 获取身份证号和姓名的关联关系 true -> 两者对应 false -> 不对应
     *
     * @param name
     * @param idCard
     * @param bizKey 业务key 为了区分调用渠道
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "us-center-idCard-pool-1")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name = HystrixPropertiesManager.CORE_SIZE, value = "10"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="2500")
    })
    boolean checkIdCardNameWithBizKey(String idCard, String name, String bizKey) throws BizException;

    @FeignHystrixCommand(threadPoolKey = "us-center-idCard-pool-1")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name = HystrixPropertiesManager.CORE_SIZE, value = "10"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="2500")
    })
    IdCardNameResult checkIdCardName(IdCardNameReq idCardNameReq) throws BizException;

    /**
     * 仅仅使用mysql中的数据来校验姓名手机号是否匹配
     *
     * @param idCardNameReq
     * @return
     */
    IdCardNameResult checkIdCardNameWithMysqlOnly(IdCardNameReq idCardNameReq);

    String getYiYuanRequestCount();

    /**
     * 每次购买身份证接口调用资源包则加上次数，更新总数
     * @param count
     * @return
     */
    boolean addYiYuanRequestCount(Integer count);

    String getYiYuanRequestAmount();
}
