package cn.com.tuia.advert.enums;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 填充广告配置类型枚举
 */
public enum UrgentTypeEnum {

    defult(0, "系统正常配置"),
    urgent(1, "应急广告填充配置");

    private Integer code;

    private String desc;

    UrgentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    private static Map<Integer, UrgentTypeEnum> enumMap = Maps.newHashMap();

    static {
        for (UrgentTypeEnum it : UrgentTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static UrgentTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
