/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.message.consumer;

import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisMsgSubscriber
implements MessageListener,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(RedisMsgSubscriber.class);
    @Resource(name="consumeExecutorService")
    private ExecutorService consumeExecutorService;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    private static final Map<RedisMessageChannel, List<AbstractRedisMessageHandle>> handlesMap = new ConcurrentHashMap<RedisMessageChannel, List<AbstractRedisMessageHandle>>();

    private RedisMsgSubscriber() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(AbstractRedisMessageHandle.class);
        for (Map.Entry entry : map.entrySet()) {
            AbstractRedisMessageHandle handle = (AbstractRedisMessageHandle)entry.getValue();
            RedisMessageHandle annotation = handle.getClass().getAnnotation(RedisMessageHandle.class);
            if (annotation == null) continue;
            RedisMessageChannel channel = annotation.value();
            ArrayList handleList = handlesMap.get((Object)channel);
            if (null == handleList) {
                handleList = Lists.newArrayList();
                handlesMap.put(channel, handleList);
            }
            handleList.add(handle);
        }
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] body = message.getBody();
        byte[] channel = message.getChannel();
        String msgContent = (String)this.redisTemplate.getValueSerializer().deserialize(body);
        String topic = (String)this.redisTemplate.getStringSerializer().deserialize(channel);
        List<AbstractRedisMessageHandle> handleList = null;
        RedisMessageChannel channelEnum = RedisMessageChannel.getByChannel(topic);
        if (channelEnum == null) {
            log.error("channel:[{}] not dedeclared", (Object)channel);
            return;
        }
        if (handlesMap != null && !handlesMap.isEmpty()) {
            handleList = handlesMap.get((Object)channelEnum);
        }
        if (handleList == null) {
            log.error("not find handle of channel:[{}]", (Object)channel);
            return;
        }
        for (AbstractRedisMessageHandle handle : handleList) {
            this.consumeExecutorService.submit(handle.createHandle(channelEnum, msgContent));
        }
    }
}

