package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: PlatformTypeEnum <br/>
 * Function:操作平台类型. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @since JDK 1.8
 */
public enum PlatformTypeEnum {

    /**
     * android
     */
    ANDROID(1, "android", "安卓"),

    /**
     * ios
     */
    IOS(2, "ios", "苹果"),

    /**
     * 其他
     */
    UNKNOW(3, "unknow", "其它");

    private String desc;

    private Integer code;

    private String cName;

    PlatformTypeEnum(Integer code, String desc, String cName) {
        this.desc = desc;
        this.code = code;
        this.cName = cName;
    }

    public String getcName() {
        return cName;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<String, PlatformTypeEnum> enumMap = Maps.newHashMap();

    static {
        for (PlatformTypeEnum it : PlatformTypeEnum.values()) {
            enumMap.put(it.getDesc(), it);
        }
    }

    public static PlatformTypeEnum getByDesc(String desc) {
        PlatformTypeEnum platformType = enumMap.get(desc.toLowerCase());
        return platformType == null ? PlatformTypeEnum.UNKNOW : platformType;
    }

}
