package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: AdvertRepeatLunchTypeEnum <br/>
 * Function: 广告重复发券切量类型. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public enum AdvertRepeatLunchTypeEnum {
    /** 老逻辑 */
    OLD(1, "老逻辑"),

    /** 新逻辑测试 */
    NEW_CUT(2, "新逻辑测试"),

    /** 新逻辑释放 */
    NEW_RELEASE(3, "新逻辑释放");

    private String desc;

    private Integer code;

    AdvertRepeatLunchTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AdvertRepeatLunchTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertRepeatLunchTypeEnum it : AdvertRepeatLunchTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertRepeatLunchTypeEnum getByName(Integer code) {
        return enumMap.get(code);
    }
}
