package cn.com.tuia.advert.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 查询adx预发券请求结果
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@Data
public class AdxLoadAdvertDto implements Serializable{

    private static final long serialVersionUID = -4820369952377186775L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 配置id
     */
    private Long orientationId;

    /**
     * 素材id
     */
    private Long materialId;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     *  预估arpu
     */
    private Double preArpu;

    /**
     * 预估出价
     */
    private Long fee;

    /**
     * 排序
     */
    private Integer rank;

    /**
     * 调价因子
     */
    private Double adjustPriceFactor;


    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 点击率
     */
    private Double ctr;

    /**
     * 是否开启提价保量模式（0=不开启，1=开启）
     */
    private Integer priceRiseMark;
    /**
     * 优化目标
     */
    private Integer cvrType;

    //转换率
    private Double cvr;
}
