package cn.com.tuia.advert.enums;

/**
 * 广告过滤顾类型枚举-
 * *
 * @author peanut.huang
 * @date 2019/4/10
 * @since JDK 1.8
 */
public enum AdvertFilterTypeEnum {


    ACTIVITY_TYPE("1.1.1.0", "投放的活动类型",AdvertFilterTypeGroupEnum.ADVERT),
    JOIN_NUM("1.1.2.0", "发券顺序",AdvertFilterTypeGroupEnum.FLOW_USER),
    PERIOD("1.1.3.0", "投放时段",AdvertFilterTypeGroupEnum.ADVERT),
    BUDGET_PER_DAY("1.1.4.0", "配置日预算",AdvertFilterTypeGroupEnum.ADVERT),

    USER_INTEREST("1.2.1.0", "定向人群",AdvertFilterTypeGroupEnum.FLOW_USER),

    REGION("1.2.5.0", "投放地域",AdvertFilterTypeGroupEnum.FLOW_USER),
    ADX_ORIENT_DATA("1.2.6.0", "adx定向数据",AdvertFilterTypeGroupEnum.OTHER),
    DEVICE("1.2.7.0", "设备号定向",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),

    TARGET_APP("1.3.1.0", "定向媒体",AdvertFilterTypeGroupEnum.ADVERT),
    LIMIT_APP("1.3.2.0", "限流媒体",AdvertFilterTypeGroupEnum.ADVERT),
    BANNED_APP_FLOW("1.3.3.0", "屏蔽流量",AdvertFilterTypeGroupEnum.ADVERT),
    BANNED_TAG("1.3.4.0", "屏蔽标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_INDUSTRY_TAG("1.3.4.1", "屏蔽行业标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_RESOURCE_TAG("1.3.4.2", "屏蔽资源标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_ATTRIBUTE_TAG("1.3.4.3", "屏蔽属性标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_PROMOTEURL_TAG("1.3.4.4", "屏蔽落地页标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_MATERIAL_TAG("1.3.4.5", "屏蔽素材标签",AdvertFilterTypeGroupEnum.ADVERT),

    BANNED_URL("1.3.5.0", "屏蔽落地页链接",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    SPECIAL_APP("1.3.6.0", "特殊广告媒体过滤",AdvertFilterTypeGroupEnum.ADVERT),
    SELECT_ADVERT("1.3.7.0", "媒体广告互选",AdvertFilterTypeGroupEnum.FLOW_MEDIA),

    TARGET_ACTIVITY("1.3.9.0", "定向活动",AdvertFilterTypeGroupEnum.ADVERT),
    SLOT_BLACKLIST("1.3.10.0", "媒体广告位黑名单",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    SLOT_KEYWORD("1.3.11.0", "媒体广告位关键词过滤",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    SLOT_NEWTRADE_KEYWORD("1.3.11.1", "媒体广告位新行业关键词过滤",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    FREE_ADVERT("1.3.11.2", "免费券过滤",AdvertFilterTypeGroupEnum.ADVERT),
    IQIYI_URL_FILTER("1.3.12.0", "爱奇艺URL过滤",AdvertFilterTypeGroupEnum.ADVERT),
    CHOOSE_ADVERT("1.3.13.0", "广告位定制可投广告",AdvertFilterTypeGroupEnum.FLOW_MEDIA),

    BANNED_OPKPROMOTEURL_TAG("1.3.14.0", "配置落地页标签屏蔽",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_MAINANDOPKPROMOTEURL_TAG("1.3.14.1", "主链接和配置落地页标签都被屏蔽",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    BANNED_MAINPROMOTEURL_TAG("1.3.14.2", "没有配置落地页,主链接标签被屏蔽",AdvertFilterTypeGroupEnum.FLOW_MEDIA),
    ADX_PLAN("1.3.15.0","adx定向计划过滤",AdvertFilterTypeGroupEnum.ADVERT),
    RESOURCE_TAG_ADVERT_CLICKED("1.3.16.0","广告资源重复点击过滤",AdvertFilterTypeGroupEnum.ADVERT),
    OCPC_FILTER("1.3.17.0","ocpc广告过滤",AdvertFilterTypeGroupEnum.ADVERT),

    PLATFORM("1.4.1.0", "操作平台系统",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),
    NETWORK_TYPE("1.4.2.0", "网络类型",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),
    OPERATORS("1.4.3.0", "网络运营商",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),
    BRAND_NAME("1.4.4.0", "设备品牌",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),
    BRAND_LEVEL("1.4.5.0", "设备价值",AdvertFilterTypeGroupEnum.FLOW_DEVICE_NETWORK),
    TRANSFORM_PEOPLE("1.4.6.0","已转化人群过滤",AdvertFilterTypeGroupEnum.FLOW_USER),


    REPEAT_LUNCH("1.5.0.0", "重复发券",AdvertFilterTypeGroupEnum.PLATFORM_RULE),
    REPEAT_EXPOSURE("1.5.1.0", "重复曝光",AdvertFilterTypeGroupEnum.ADVERT),

    ACTIVITY_ADVERT("2.1.0.0", "活动定制广告",AdvertFilterTypeGroupEnum.OTHER),
    //废弃
    ACTIVITY_WHITE("2.2.0.0", "活动白名单",AdvertFilterTypeGroupEnum.OTHER),
    //废弃
    APP_WHITE("2.3.0.0", "媒体白名单",AdvertFilterTypeGroupEnum.OTHER),
    NEW_APP_TEST("2.4.0.0", "新媒体测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    DMP_TEST("2.5.0.0", "DMP测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    BLOCK_WHITELIST("2.6.0.0", "区块白名单",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    BID_FLOOR("2.7.0.0", "底价过滤",AdvertFilterTypeGroupEnum.PLATFORM_RULE),
    LOW_NEEDS_AD("2.8.0.0","用户低意向广告过滤",AdvertFilterTypeGroupEnum.OTHER),
    WHITE_LIST_FILTER("2.9.0.0","聚合白名单过滤",AdvertFilterTypeGroupEnum.FLOW_MEDIA),

    BEFORE_RECOMMEND("3.1.0.0", "推荐之前",AdvertFilterTypeGroupEnum.PLATFORM_RULE),
    RECOMMEND_FAILED("3.2.0.0", "竞价失败",AdvertFilterTypeGroupEnum.OTHER),
    UNKNOW("3.3.0.0", "未知",AdvertFilterTypeGroupEnum.OTHER),
    ORDER_CUSTOM_FIRST("3.4.1.0", "发券次序定制广告过滤-首位",AdvertFilterTypeGroupEnum.PLATFORM_RULE),
    ORDER_CUSTOM_OTHER("3.4.2.0", "发券次序定制广告过滤-非首位",AdvertFilterTypeGroupEnum.PLATFORM_RULE),

    URGENT_ADVERT("4.1.1.0","应急广告填充",AdvertFilterTypeGroupEnum.ADVERT ),
    ACTIVITY_MATERIAL_TYPE("5.1.1.0","活动素材类型",AdvertFilterTypeGroupEnum.ADVERT),
    VIDEO_MATERIAL_TYPE("5.2.1.0","激励视频素材类型",AdvertFilterTypeGroupEnum.ADVERT),

    ACTIVITY_PRE_TYPE_NEW_TRADE_TAG("6.1.1.0","新行业标签",AdvertFilterTypeGroupEnum.FLOW_MEDIA),

    MICRO_PROGRAM_AB_TEST("7.1.1.0","小程序ab测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    NET_CARRIER_AB_TEST("7.1.1.1","三网识别ab测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    QUICK_APP("7.1.1.2", "快应用ab测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    MEDIA_TAG("7.1.1.3","媒体回传标签测试",AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    MEDIA_SHUNT_AB_TEST("7.1.1.4", "小媒体聚合填充分流ab测试", AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),
    MEDIA_ORIENT_AB_TEST("7.1.1.5","小媒体突破定向限制分流实验", AdvertFilterTypeGroupEnum.PLATFORM_SPECIAL),

    REPEAT_SHOW_NO_PUT_MATERIAL("8.2.1.4", "重复曝光无可投素材",AdvertFilterTypeGroupEnum.ADVERT),
    REPEAT_SHOW_NO_PUT_MATERIAL_FOUR("8.2.1.5", "曝光实验组4重复曝光无可投素材",AdvertFilterTypeGroupEnum.ADVERT),
    REPEAT_SHOW_NO_PUT_MATERIAL_THREE("8.2.1.3", "曝光实验组重复曝光无可投素材",AdvertFilterTypeGroupEnum.ADVERT),
    REPEAT_SHOW_NO_PUT_MATERIAL_TWO("8.2.1.2", "常规实验组重复曝光无可投素材",AdvertFilterTypeGroupEnum.ADVERT),
    REPEAT_SHOW_NO_PUT_MATERIAL_ONE("8.2.1.1", "常规对照组重复曝光无可投素材",AdvertFilterTypeGroupEnum.ADVERT),

    QUICK_APP_BLACK_LIST("9.1.1.0", "快应用盘古黑名单过滤", AdvertFilterTypeGroupEnum.PLATFORM_RULE),
    ZERO_START_CONFIG_FIRST_REPLACE("10.1.1.0", "冷启动首张券发券替换过滤", AdvertFilterTypeGroupEnum.PLATFORM_RULE),

    ;

    private String code;

    private String desc;


    private AdvertFilterTypeGroupEnum advertFilterTypeGroupEnum;

    AdvertFilterTypeEnum(String code, String desc, AdvertFilterTypeGroupEnum advertFilterTypeGroupEnum) {
        this.code = code;
        this.desc = desc;
        this.advertFilterTypeGroupEnum = advertFilterTypeGroupEnum;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public AdvertFilterTypeGroupEnum getAdvertFilterTypeGroupEnum() {
        return advertFilterTypeGroupEnum;
    }


}
