/**
 * Project Name:tuia-client
 * File Name:RedisPreKey.java
 * Package Name:cn.com.tuia.advert.cache
 * Date:2018年9月19日上午11:42:23
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.tuia.advert.cache;

import java.io.Serializable;

/**
 * ClassName:RedisPreKey <br/>
 * Function: redis前置key. <br/>
 * Date:     2018年9月19日 上午11:42:23 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class RedisPreKey implements Serializable{

    private static final long serialVersionUID = -3126874323418348060L;
    
    /** 曝光*/
    public static final String KEY_EXPOSURE = "exposure";
    /** 点击*/
    public static final String KEY_CLICK = "click";
    /** 点击*/
    public static final String KEY_EF_CLICK = "efClick";
    /** 发券*/
    public static final String KEY_LAUNCH = "launch";
    /** 广告计费*/
    public static final String KEY_ADVERT_CONSUME_FEE = "ADVERT_FEE_NEW";
    /** 推广计划计费*/
    public static final String KEY_ADVERT_PLAN_CONSUME_FEE = "ADVERT_PLAN_FEE_NEW";
    /** 账户计费*/
    public static final String KEY_ACCOUNT_CONSUME_FEE = "ACCOUNT_FEE_NEW";
    /** 账户余额*/
    public static final String KEY_ACCOUNT_BALANCE = "ACCOUNT_BLANCE";
    /** 寡头流量广告10分钟前预估消耗缓存key */
    public static final String KEY_OLIGARCH_FLOW_TEN_MIN_CONSUME = "OLIGARCH_FLOW_TEN_MIN_CONSUME";
    /** 寡头流量广告10分钟前发券缓存key */
    public static final String KEY_OLIGARCH_FLOW_TEN_MIN_LUNCH = "OLIGARCH_FLOW_TEN_MIN_LUNCH";
    /** 寡头流量广告发券缓存key */
    public static final String KEY_OLIGARCH_FLOW_LUNCH = "OLIGARCH_FLOW_LUNCH";
    /** 福利流量缓存key*/
    public static final String KEY_WELFARE_FLOW_LAUNCH = "WELFARE_FLOW_LAUNCH";
    @Deprecated
    /** 新媒体10天内全部发券*/
    public static final String KEY_NEW_APP_10DAY_LAUNCH = "NEW_APP_10DAY_LAUNCH";
    @Deprecated
    /** 广告在新媒体的当日发券*/
    public static final String KEY_NEW_APP_DAY_LAUNCH = "NEW_APP_DAY_LAUNCH";
    @Deprecated
    /** 广告在新媒体的当日点击*/
    public static final String KEY_NEW_APP_DAY_CLICK = "NEW_APP_DAY_CLICK";
    @Deprecated
    /** 广告在媒体上行业上10日内发券 */
    public static final String KEY_NEW_APP_TRADE_LAUNCH = "NEW_APP_TRADE_LAUNCH";
    @Deprecated
    /** 广告在媒体上行业10日内点击 */
    public static final String KEY_NEW_APP_TRADE_CLICK = "NEW_APP_TRADE_CLICK";
    
    /** 不能继续测试的新媒体 */
    @Deprecated
    public static final String KEY_NEW_APP_CANNOT_TEST = "NEW_APP_CANNOT_TEST";
    /** 新媒体上不能继续测试的广告 */
    @Deprecated
    public static final String KEY_NEW_APP_CANNOT_TEST_ADVERT = "NEW_APP_CANNOT_TEST_ADVERT";
    /** 新媒体上不能继续测试的行业*/
    @Deprecated
    public static final String KEY_NEW_APP_CANNOT_TEST_TRADE = "EW_APP_CANNOT_TEST_TRADE";
    /** 当日新媒体上不能继续测试的行业*/
    @Deprecated
    public static final String KEY_NEW_APP_TODAY_CANNOT_TEST_TRADE = "NEW_APP_TODAY_CANNOT_TEST_TRADE";
}

