/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum AdvertSubtypeEnum {
    CVR(0, "\u843d\u5730\u9875\u8f6c\u5316"),
    INSTALL(1, "\u5b89\u88c5"),
    START(2, "\u6fc0\u6d3b(\u542f\u52a8)"),
    REGISTER(3, "\u6ce8\u518c"),
    ACTIVITY(4, "\u6fc0\u6d3b"),
    LOGIN(5, "\u767b\u5f55"),
    PAY(6, "\u4ed8\u8d39"),
    ENTRY(7, "\u8fdb\u4ef6"),
    FINISH(8, "\u5b8c\u4ef6"),
    SIGN_FOR(9, "\u7b7e\u6536"),
    DENY(10, "\u62d2\u7b7e"),
    OUT_ORDER(11, "\u51fa\u5355"),
    ORDER_CANCEL(12, "\u8ba2\u5355\u53d6\u6d88"),
    BUSI_AUDIT_NO(13, "\u5546\u5bb6\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    AUDIT_PASS(14, "\u5ba1\u6838\u901a\u8fc7"),
    CUST_AUDIT_NO(15, "\u5ba2\u670d\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    BUSI_CANCEL_SEND(16, "\u5546\u5bb6\u53d6\u6d88\u53d1\u8d27"),
    CUST_CANCEL_SEND(17, "\u5ba2\u670d\u53d6\u6d88\u53d1\u8d27"),
    ROBOT_CANCEL_SEND(18, "\u673a\u5668\u4eba\u53d6\u6d88\u53d1\u8d27"),
    LANDING_TIME_CONSUME(19, "\u843d\u5730\u9875\u9996\u9875\u505c\u7559\u65f6\u957f\u8d85\u8fc75s"),
    EFFECT_ORDER_COUNT(23, "\u6709\u6548\u8ba2\u5355\u6570"),
    FULL_PAYMENT(24, "\u5168\u91cf\u4ed8\u8d39");

    public static HashMap<Integer, AdvertSubtypeEnum> ADVERT_SUBTYPE_MAPPING;
    private Integer subtype;
    private String desc;
    private static Map<Integer, AdvertSubtypeEnum> enumMap;

    public Integer getSubtype() {
        return this.subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private AdvertSubtypeEnum(Integer subtype, String desc) {
        this.subtype = subtype;
        this.desc = desc;
    }

    public static AdvertSubtypeEnum getSubtypeEnumBySubtype(Integer subtype) {
        return ADVERT_SUBTYPE_MAPPING.get(subtype);
    }

    public static AdvertSubtypeEnum getBySubtype(Integer subtype) {
        return enumMap.get(subtype);
    }

    static {
        ADVERT_SUBTYPE_MAPPING = Maps.newHashMap();
        for (AdvertSubtypeEnum advertSubtypeEnum : AdvertSubtypeEnum.values()) {
            ADVERT_SUBTYPE_MAPPING.put(advertSubtypeEnum.getSubtype(), advertSubtypeEnum);
        }
        enumMap = Maps.newHashMap();
        for (AdvertSubtypeEnum it : AdvertSubtypeEnum.values()) {
            enumMap.put(it.getSubtype(), it);
        }
    }
}

