package cn.com.tuia.advert.service;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.tuia.advert.fallback.IAdxServiceFallbackImpl;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

/**
 * adx出券请求接口
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@AdvancedFeignClient(fallback = IAdxServiceFallbackImpl.class)
public interface IAdxService {

    /**
     * adx发券请求
     *
     * @param req  req#adxLoadType，1：预发券，2：真实发券
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#loadAdvert}
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
        @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
        @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "100")
    })
    ObtainAdvertRsp loadAdvert(ObtainAdvertReq req);
}
