/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import cn.com.tuia.advert.enums.AdvertSubtypeEnum;
import com.google.common.collect.Maps;
import java.util.Map;

public enum CVRTypeEnum {
    CVR(0, "cvr"),
    START(2, "\u6fc0\u6d3b"),
    REGISTE(3, "\u6ce8\u518c");

    private Integer cvrType;
    private String desc;
    private static Map<Integer, CVRTypeEnum> enumMap;

    private CVRTypeEnum(Integer cvrType, String desc) {
        this.cvrType = cvrType;
        this.desc = desc;
    }

    public static CVRTypeEnum getByCvrType(Integer cvrType) {
        return enumMap.get(cvrType);
    }

    public static Integer changeSubtypeToCVRType(Integer subtype) {
        AdvertSubtypeEnum enumType = AdvertSubtypeEnum.getBySubtype(subtype);
        switch (enumType) {
            case CVR: 
            case SIGN_FOR: {
                return CVR.getCvrType();
            }
        }
        CVRTypeEnum cvrTypeEnum = enumMap.get(subtype);
        if (cvrTypeEnum != null) {
            return cvrTypeEnum.getCvrType();
        }
        return CVR.getCvrType();
    }

    public Integer getCvrType() {
        return this.cvrType;
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    static {
        enumMap = Maps.newHashMap();
        for (CVRTypeEnum it : CVRTypeEnum.values()) {
            enumMap.put(it.getCvrType(), it);
        }
    }
}

