package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AbnormalMonitoringConditionTypeEnum <br/>
 * Function: 广告异常监控-前置条件枚举. <br/>
 * 前置条件：1-广告消耗，2-配置消耗，3-单媒体消耗，4-单媒体发券，5-广告计费点击，6-配置计费点击
 * date: 2019年3月26日 下午6:54:16 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AbnormalMonitoringConditionTypeEnum {
    /** 广告消耗 */
    ADVERT_CONSUME(1, "广告消耗"),

    /** 配置消耗 */
    ORIENT_CONSUME(2, "配置消耗"),

    /** 单媒体在广告上消耗 */
    ORIENT_APP_CONSUME(3, "单媒体在广告上消耗"),

    /** 配置下媒体发券 */
    ORIENT_APP_LUNCH(4, "配置下媒体发券"),
    
    /** 广告计费点击 */
    ADVERT_EF_CLICK(5, "广告计费点击"),

    /** 配置计费点击 */
    ORIENT_EF_CLICK(6, "配置计费点击"),

    /** 广告落地页成本 */
    ADVERT_LOAD_COST(7, "广告落地页成本"),

    /** 单媒体在配置上消耗 */
    ORIENT_APP_PKG_CONSUME(8, "单媒体在配置上消耗"),;

    private String desc;

    private Integer code;

    AbnormalMonitoringConditionTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AbnormalMonitoringConditionTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AbnormalMonitoringConditionTypeEnum it : AbnormalMonitoringConditionTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AbnormalMonitoringConditionTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
