/**
 * 文件名： ObtainAdvertRsp.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月27日 下午10:33:41
 */
package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 福袋请求广告接口返回结果 <br/>
 *
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午10:33:41
 * @version:
 */
public class ObtainAdvertRsp implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The result. */
    private boolean           result;

    /**
     * 订单ID
     */
    private String            orderId;

    /** 广告ID. */
    private long              advertId;

    /** 广告所属广告主名称. */
    private String            advertiserName;

    /** 优惠券描述，即详情文案. */
    private String            couponRemark;

    /** 详情图的url地址. */
    private String            bannerPngUrl;

    /** 缩略图的url地址. */
    private String            thumbnailPngUrl;

    /** 券的标题. */
    private String            title;

    /** 券的副标题. */
    private String            viceTitle;

    /** 优惠券有效期的开始时间. */
    private String            startValid;

    /** 优惠券有效期的结束时间. */
    private String            endValid;

    /** 推广网址. */
    private String            promoteUrl;

    /** 对特殊应用隐藏使用按钮(0：否，1：是). */
    private int               specialHide;

    /** 该优惠券的价格(分). */
    private long              couponPrice;

    /** 优惠券类型：1-链接券；2-可重复券；3-普通券. */
    private int               couponType;

    /** 是否为微信券(0：否，1：是) ,只有couponType=2 or couponType=3时有效. */
    private int               isWeixin;

    /** 券码. */
    private String            codeContent;

    /** 券密码. */
    private String            codePasswd;

    /** 按钮文案 */
    private String            buttonText;

    /** 广告位ID */
    private Long              slotId;

    /** 广告订单Id */
    private Long              advertOrderId;

    /** 素材ID  确认展示的素材*/
    private Long              materialId;

    /**
     * 定向配置包ID
     */
    private Long                adSpecId;

    /***屏蔽策略类型 @StrategyTypeEnum*/
    private String strategyType;

    /**
     * 轮流投放策略类型
     */
    private String turnsStrategyType;

    private boolean privilege;

    //1-激励广告ARPU值>广告ARPU值; 0-激励广告ARPU值<=广告ARPU值
    private Integer encArpuResult;

    /**  日志扩展map */
    private Map<String, Object> logExtMap;

    /**  实验编号 */
    private String exps;

    /**  0 = 普通流量 2 = 优质流量*/
    private Long flowTag;
    
    /** 兑吧广告位id **/
    private Long    duibaSlotId;

    /**
     * 是否为少量试投  0：正常素材，1：少量试投素材, 2:从少量试投变为正常
     */
    private Integer isSmallPutOn;

    /** 是否是免费券 0:免费券，1:付费券 **/
    private Integer isFreeAdvert;

    /**
     * adx预发券请求返回列表
     */
    List<AdxLoadAdvertDto> adxAdvertList;

    /**
     * 包名
     */
    private String packageName;

    /**
     * app名称
     */
    private String appName;

    public List<AdxLoadAdvertDto> getAdxAdvertList() {
        return adxAdvertList;
    }

    public void setAdxAdvertList(List<AdxLoadAdvertDto> adxAdvertList) {
        this.adxAdvertList = adxAdvertList;
    }

    public Integer getIsFreeAdvert() {
        return isFreeAdvert;
    }

    public void setIsFreeAdvert(Integer isFreeAdvert) {
        this.isFreeAdvert = isFreeAdvert;
    }

    public Integer getIsSmallPutOn() {
        return isSmallPutOn;
    }

    public void setIsSmallPutOn(Integer isSmallPutOn) {
        this.isSmallPutOn = isSmallPutOn;
    }

    public Long getFlowTag() {
        return flowTag;
    }

    public void setFlowTag(Long flowTag) {
        this.flowTag = flowTag;
    }

    public String getExps() {
        return exps;
    }

    public void setExps(String exps) {
        this.exps = exps;
    }

    public Integer getEncArpuResult() {
        return encArpuResult;
    }

    public void setEncArpuResult(Integer encArpuResult) {
        this.encArpuResult = encArpuResult;
    }

    /**
     * logExtMap.
     *
     * @return  the logExtMap
     */
    public Map<String, Object> getLogExtMap() {
        return logExtMap;
    }

    /**
     * logExtMap.
     *
     * @param   logExtMap    the logExtMap to set
     */
    public void setLogExtMap(Map<String, Object> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public Long getMaterialId() {
        return materialId;
    }


    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * advertOrderId.
     *
     * @return the advertOrderId
     * @since JDK 1.6
     */
    public Long getAdvertOrderId() {
        return advertOrderId;
    }

    /**
     * advertOrderId.
     *
     * @param advertOrderId the advertOrderId to set
     * @since JDK 1.6
     */
    public void setAdvertOrderId(Long advertOrderId) {
        this.advertOrderId = advertOrderId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    /**
     * specialHide.
     *
     * @return the specialHide
     * @since JDK 1.7
     */
    public int getSpecialHide() {
        return specialHide;
    }

    /**
     * specialHide.
     *
     * @param specialHide the specialHide to set
     * @since JDK 1.7
     */
    public void setSpecialHide(int specialHide) {
        this.specialHide = specialHide;
    }

    /**
     * isWeixin.
     *
     * @return the isWeixin
     * @since JDK 1.7
     */
    public int getIsWeixin() {
        return isWeixin;
    }

    /**
     * isWeixin.
     *
     * @param isWeixin the checks if is weixin
     * @since JDK 1.7
     */
    public void setIsWeixin(int isWeixin) {
        this.isWeixin = isWeixin;
    }

    /**
     * Checks if is result.
     *
     * @return the result
     */
    public boolean isResult() {
        return result;
    }

    /**
     * Sets the result.
     *
     * @param result the result to set
     */
    public void setResult(boolean result) {
        this.result = result;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the advertiser name.
     *
     * @return the advertiser name
     */
    public String getAdvertiserName() {
        return advertiserName;
    }

    /**
     * Sets the advertiser name.
     *
     * @param advertiserName the advertiser name
     */
    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    /**
     * Gets the coupon remark.
     *
     * @return the coupon remark
     */
    public String getCouponRemark() {
        return couponRemark;
    }

    /**
     * Sets the coupon remark.
     *
     * @param couponRemark the coupon remark
     */
    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    /**
     * Gets the banner png url.
     *
     * @return the banner png url
     */
    public String getBannerPngUrl() {
        return bannerPngUrl;
    }

    /**
     * Sets the banner png url.
     *
     * @param bannerPngUrl the banner png url
     */
    public void setBannerPngUrl(String bannerPngUrl) {
        this.bannerPngUrl = bannerPngUrl;
    }

    /**
     * Gets the thumbnail png url.
     *
     * @return the thumbnail png url
     */
    public String getThumbnailPngUrl() {
        return thumbnailPngUrl;
    }

    /**
     * Sets the thumbnail png url.
     *
     * @param thumbnailPngUrl the thumbnail png url
     */
    public void setThumbnailPngUrl(String thumbnailPngUrl) {
        this.thumbnailPngUrl = thumbnailPngUrl;
    }

    /**
     * Gets the title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Gets the vice title.
     *
     * @return the vice title
     */
    public String getViceTitle() {
        return viceTitle;
    }

    /**
     * Sets the vice title.
     *
     * @param viceTitle the vice title
     */
    public void setViceTitle(String viceTitle) {
        this.viceTitle = viceTitle;
    }

    /**
     * Gets the start valid.
     *
     * @return the start valid
     */
    public String getStartValid() {
        return startValid;
    }

    /**
     * Sets the start valid.
     *
     * @param startValid the start valid
     */
    public void setStartValid(String startValid) {
        this.startValid = startValid;
    }

    /**
     * Gets the end valid.
     *
     * @return the end valid
     */
    public String getEndValid() {
        return endValid;
    }

    /**
     * Sets the end valid.
     *
     * @param endValid the end valid
     */
    public void setEndValid(String endValid) {
        this.endValid = endValid;
    }

    /**
     * Gets the promote url.
     *
     * @return the promote url
     */
    public String getPromoteUrl() {
        return promoteUrl;
    }

    /**
     * Sets the promote url.
     *
     * @param promoteUrl the promote url
     */
    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    /**
     * Gets the coupon price.
     *
     * @return the coupon price
     */
    public long getCouponPrice() {
        return couponPrice;
    }

    /**
     * Sets the coupon price.
     *
     * @param couponPrice the coupon price
     */
    public void setCouponPrice(long couponPrice) {
        this.couponPrice = couponPrice;
    }

    /**
     * Gets the coupon type.
     *
     * @return the coupon type
     */
    public int getCouponType() {
        return couponType;
    }

    /**
     * Sets the coupon type.
     *
     * @param couponType the coupon type
     */
    public void setCouponType(int couponType) {
        this.couponType = couponType;
    }

    /**
     * Gets the code content.
     *
     * @return the code content
     */
    public String getCodeContent() {
        return codeContent;
    }

    /**
     * Sets the code content.
     *
     * @param codeContent the code content
     */
    public void setCodeContent(String codeContent) {
        this.codeContent = codeContent;
    }

    /**
     * Gets the code passwd.
     *
     * @return the code passwd
     */
    public String getCodePasswd() {
        return codePasswd;
    }

    /**
     * Sets the code passwd.
     *
     * @param codePasswd the code passwd
     */
    public void setCodePasswd(String codePasswd) {
        this.codePasswd = codePasswd;
    }

    public Long getAdSpecId() {
        return adSpecId;
    }

    public void setAdSpecId(Long adSpecId) {
        this.adSpecId = adSpecId;
    }

    public String getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(String strategyType) {
        this.strategyType = strategyType;
    }


    public String getTurnsStrategyType() {
        return turnsStrategyType;
    }


    public void setTurnsStrategyType(String turnsStrategyType) {
        this.turnsStrategyType = turnsStrategyType;
    }

    public boolean isPrivilege() {
        return privilege;
    }

    public void setPrivilege(boolean privilege) {
        this.privilege = privilege;
    }

    
    public Long getDuibaSlotId() {
        return duibaSlotId;
    }

    
    public void setDuibaSlotId(Long duibaSlotId) {
        this.duibaSlotId = duibaSlotId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}
