/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.apache.commons.lang.StringUtils;

public enum AdxSceneEnum {
    ADX_MEITUAN("0", "\u7f8e\u56e2adx"),
    ADX_API("1", "\u4e92\u52a8\u76f4\u6295API"),
    ADX_DIRECT("2", "adx\u76f4\u6295"),
    ADX_ACT("3", "adx\u53d1\u5238"),
    SDK_DIRECT("4", "sdk\u76f4\u6295"),
    UNKNOWN("-1", "\u672a\u77e5");

    private String code;
    private String desc;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private AdxSceneEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static AdxSceneEnum getAdxMeituanByCode(String code) {
        for (AdxSceneEnum adxSceneEnum : AdxSceneEnum.values()) {
            if (!adxSceneEnum.getCode().equals(code)) continue;
            return adxSceneEnum;
        }
        return UNKNOWN;
    }

    public static String getAdxSceneType(String adxMediaType) {
        if (StringUtils.equals((String)adxMediaType, (String)ADX_DIRECT.getCode()) || StringUtils.equals((String)adxMediaType, (String)SDK_DIRECT.getCode())) {
            return adxMediaType;
        }
        return ADX_ACT.getCode();
    }

    public static String getAdxSceneType(ObtainAdvertReq req) {
        return AdxSceneEnum.getAdxSceneType("" + req.getAdxMediaType());
    }

    public static String getAdxSceneType(AdxLogReq req) {
        return AdxSceneEnum.getAdxSceneType(req.getAdxMediaType());
    }
}

