package cn.com.tuia.advert.service;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.tuia.advert.model.AdvertDirectDto;
import cn.com.tuia.advert.model.DirectAdvertCouponDto;
import cn.com.tuia.advert.model.DirectAdvertLogReq;
import cn.com.tuia.advert.model.DirectObtainAdvertReq;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月01日 09:50
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface IAdvertDirectService {


    /**
     * 获取有效的广告 给活动管理端调用
     * @param advertIds 需要过滤的广告列表
     * @return
     */
    @RequestMapping("/getValidAdvertsById")
    DubboResult<List<AdvertDirectDto>> getValidAdverts(List<Long> advertIds);


    /**
     * 获取有效的广告
     * @param directObtainAdvertReq
     * @return
     */
    @RequestMapping("/getValidAdvertsByReq")
    DubboResult<List<AdvertDirectDto>> getValidAdverts(DirectObtainAdvertReq directObtainAdvertReq);

    /**
     * 发券-直投广告
     * @param req
     * @return
     */
    DubboResult<Boolean> directAdvert(DirectAdvertLogReq req);

    /**
     * 广告id查询优惠券信息
     *
     * @param advertId  计划id
     * @return          优惠券实体，异常情况下将返回null
     */
    DirectAdvertCouponDto getDirectAdvertCoupon(Long advertId);

}
