package cn.com.duiba.user.service.api.enums.user;

import lombok.Getter;

/**
 * 用户分组 子分组
 * 场景：
 * 1。有unionId时，是登陆场景使用
 * 2。没有unionId时，比如其他系统使用，则使用userId区分用户分组
 * @author dugq
 * @date 2021/7/19 2:39 下午
 */
@Getter
public enum UserSubGroupEnum {

    A1("A1","加密unionId/userId尾号为基数，同时除以2后为基数的用户"),
    A2("A2","加密unionId/userId尾号为基数，同时除以2后为偶数的用户"),
    B1("B1","加密unionId/userId尾号为偶数，同时除以2后为基数的用户"),
    B2("B2","加密unionId/userId尾号为偶数，同时除以2后为偶数的用户");

    private String type;
    private String desc;

    UserSubGroupEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据用户unioncode 最后一位获取用户类型
     * @param c unioncode最后一位
     * @return 用户类型
     */
    public static UserSubGroupEnum getByLastCharOfUnionCode(char c) {
        if (c % 2 ==0){
            if (c/2 % 2 ==0){
                return B2;
            }else{
                return B1;
            }
        }else{
            if (c/2 % 2 ==0){
                return A2;
            }else{
                return A1;
            }
        }
    }

    /**
     * 根据用户id获取用户类型
     * @param liveUserId 用户id
     * @return 用户类型
     */
    public static UserSubGroupEnum getByLiveUserId(Long liveUserId) {
        if (liveUserId % 2 ==0){
            if (liveUserId/2 % 2 ==0){
                return B2;
            }else{
                return B1;
            }
        }else{
            if (liveUserId/2 % 2 ==0){
                return A2;
            }else{
                return A1;
            }
        }
    }
}
