package cn.com.duiba.user.service.api.enums.user;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum UserExtTypeEnum {

    OA("oa", "客集集公众号"),
    MP("mp", "小程序"),
    VIP("vip","客集集VIP公众号"),
    FISSION_MP("fission_mp", "微信裂变小程序"),
    GAME_MP("game_mp", "抽奖模板小程序"),
    GREETING_MP("greet_mp", "节日贺卡小程序"),
    LIVE_USER_MP("live_user", "直播用户端"),
    LIVE_ANCHOR_MP("liveAnchor", "直播主端"),
    LIVE_OA("live_oa", "直播公众号"),
    VOCIE_LIVE_MP("voice_user", "语音直播小程序"),
    REWARD_LIVE_MP("reward_mp", "发奖小程序"),
    AI_VIDEO_MP("ai_video", "AI跟拍小程序"),
    VIDEO_APP("video_app", "短视频APP"),
    RISK_MP("risk_mp", "风险测评小程序"),

    //-----------------------------------------------
    /**
     * !!!important 这不是数据库类型哦！！！仅在查询时使用。
     *  场景： 在某些情况下，需求要求： 消息优先发送客集集VIP公众号，再发客集集公众号。在查询时使用此对象
     * 必须经过userExtService处理
     */
    VIP_OA("vipOa","优先客集集VIP公众号，其次客集集公众号"),
    CLIENT_MP("client_mp","客户小程序")

    ;

    private String code;
    private String desc;

    UserExtTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UserExtTypeEnum of(String code) {
        if (code == null) {
            return null;
        }
        for (UserExtTypeEnum typeEnum : UserExtTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        throw new UnsupportedOperationException("不支持的ext类型");
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
