package cn.com.duiba.user.service.api.dto.oa;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author dugq
 * @date 2021/1/14 3:38 下午
 */
@Data
public class OfficialAccountsExtDto implements Serializable {
    private static final long serialVersionUID = 16062254585485416L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *公众号ID
     * not null default = null
     */
    private Long oaId;

    /**
     *
     *接口调用凭证的刷新凭证
     * max length = 128
     * not null default = null
     */
    private String refreshToken;

    /**
     *
     *公众号头像地址
     * max length = 256
     * not null default = null
     */
    private String headImg;

    /**
     *
     *公众号类型 0:订阅号 1:由历史老帐号升级后的订阅号 2:服务号
     * not null default = null
     */
    private Integer serviceTypeInfo;

    /**
     *
     *公众号认证类型：-1:未认证 0:微信认证 1:新浪微博认证 2:腾讯微博认证
     * not null default = null
     */
    private Integer verifyTypeInfo;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
