package cn.com.duiba.user.service.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.user.TestUserDto;

import java.util.List;

/**
 * 自动化测试用户remote
 * @author zhanghuifeng
 * @date 2021/11/15 15:50
 */
@AdvancedFeignClient
public interface RemoteTestUserService {

    /**
     * 根据用户id查询
     * @param userId 用户id
     * @return 执行结果
     */
    TestUserDto findByUserId(Long userId);

    /**
     * 根据用户ids查询
     * @param userIds 用户id集合
     * @return 执行结果
     */
    List<TestUserDto> findByUserIds(List<Long> userIds);

    /**
     * 插入user_id
     * @param dto
     * @return
     */
    int insert(TestUserDto dto);

    /**
     * 逻辑删除
     * @param id
     * @return
     */
    Integer delete(Long id);

    /**
     * 逻辑删除
     * @param userId 用户ID
     * @return 删除行数
     */
    Integer delByUserId(Long userId);

}
