package cn.com.duiba.user.service.api.remoteservice.wxworkuser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.wxworkuser.WxWorkUserDto;
import cn.com.duiba.user.service.api.dto.wxworkuser.UserWxWorkExtDto;
import cn.com.duiba.user.service.api.param.wxworkuser.SaveWxWorkMpUserParam;
import cn.com.duiba.user.service.api.param.wxworkuser.SaveWxWorkUserParam;

/**
 * 企微用户操作
 * @author dugq
 * @date 2021/11/26 2:07 下午
 */
@AdvancedFeignClient
public interface RemoteWxWorkUserService {

    /**
     * 保存企微用户
     */
    Long saveCorpUser(SaveWxWorkUserParam saveWxWorkUserParam);

    /**
     * 保存企微小程序用户
     */
    Long saveCorpMpUser(SaveWxWorkMpUserParam saveWxWorkMpUserParam);

    /**
     * 查询用户小程序的sessionKey
     */
    String findMpSessionKeyByUserId(Long userId, Long oaId);

    /**
     * 根据用户ID查询企微用户信息
     */
    WxWorkUserDto selectByUserId(Long userId);
    /**
     * 根据用户ID查询企微用户扩展信息
     */
    UserWxWorkExtDto selectCorpExtByUserId(Long userId);

    /**
     * 根据用户企微账号查询企微用户信息
     */
    WxWorkUserDto selectByUserKey(String corpKey, String userKey);

    /**
     * 根据用户企微账号查询企微用户信息
     */
    UserWxWorkExtDto selectExtByUserKey(String corpKey, String userKey);

    /**
     * 更新用户sessionKey
     * @param userId 用户ID
     * @param oaId 小程序ID
     * @param sessionKey 用户在小程序sessionKey
     * @return >0 更新成功
     */
    int updateSessionKey(Long userId, Long oaId, String sessionKey);
}
