package cn.com.duiba.user.service.api.remoteservice.user.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.param.user.app.SaveAppCorpUserParam;
import cn.com.duiba.user.service.api.param.user.app.UpdateAppCorpUserParam;

/**
 * 客户app用户组合业务相关
 * @author lizhi
 * @date 2021/12/2 1:33 下午
 */
@AdvancedFeignClient
public interface RemoteUserAppCorpService {

    /**
     * 如果用户不存在，保存客户app用户，存在则直接返回用户ID
     * @param param 保存所需要的参数
     * @return 用户ID，tb_users主键
     */
    Long saveIfAbsent(SaveAppCorpUserParam param);

    /**
     * 更新用户信息
     * @param param 更新参数
     * @return 执行结果
     */
    int updateUserInfo(UpdateAppCorpUserParam param);
}
