package cn.com.duiba.user.service.api.dto.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播第三方用户关联表
 *
 * @author kjj mybatis generator
 * 2023-03-03
 */
@Data
public class LiveThirdUserDto implements Serializable {
    private static final long serialVersionUID = 16778262083605452L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户id tb_users.id
     */
    private Long userId;

    /**
     * 用户id tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 第三方用户id third_type=1 表示中信公众号openId ，third_type=3 表示湖南中烟橙杏id
     * max length = 64
     */
    private String thirdUserId;

    /**
     * 第三方类型 1-中信信用卡
     * {@link cn.com.duiba.user.service.api.enums.third.ThirdUserTypeEnum}
     */
    private Integer thirdType;

    /**
     * 扩展字段1 third_type=3 ，存入黑灰名单
     */
    private String thirdExt1;

    /**
     * 扩展字段2 third_type=3 ，存入是否是扫码用户
     */
    private String thirdExt2;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}