package cn.com.duiba.user.service.api.enums.wxwork;

/**
 * @author dugq
 * @date 2021/11/22 5:42 下午
 */
public enum WxWorkCorpTypeEnum {

    THIRD_CORP(1,"第三方企微账号"),
    PROVIDER_CORP(2,"服务商"),
    ;
    private final Integer code;
    private final String value;

    WxWorkCorpTypeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    /**
     * 根据编码查询枚举。
     *
     * @param code 编码。
     * @return 枚举。
     */
    public static WxWorkCorpTypeEnum getByCode(Integer code) {
        for (WxWorkCorpTypeEnum value : WxWorkCorpTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

}
