package cn.com.duiba.user.service.api.remoteservice.liveuser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteLiveUserNewComerService {

    /**
     * 查询是否指定公司的新用户，如果是新用户则插入来源直播，如果不是判断来源直播是否和指定直播相同
     * @param liveUserIds 用户列表
     * @param liveId 直播ID
     * @param liveCompanyId 公司ID
     * @return 是否指定公司的新用户，并且来源于指定直播 (key不存在时表示查询失败，自行降级处理)
     */
    Map<Long, Boolean> batchInsertAndSelectIsNewComer(List<Long> liveUserIds, Long liveId, Long liveCompanyId);

    /**
     * 查询是否指定公司来源于指定直播的新用户
     * @param liveUserIds 用户列表
     * @param liveId 直播ID
     * @param liveCompanyId 公司ID
     * @return 是否指定公司的新用户，并且来源于指定直播(key不存在时表示查询失败，自行降级处理)
     */
    Map<Long, Boolean> batchSelectIsNewComer(List<Long> liveUserIds, Long liveId, Long liveCompanyId);
}
