package cn.com.duiba.user.service.api.remoteservice.shorturl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.shorturl.ShortUrlDto;
import cn.com.duiba.user.service.api.param.PageQuery;

import java.util.List;

/**
 * 短链服务
 *
 * @author lizhi
 * @date 2020/4/8 8:17 PM
 */
@AdvancedFeignClient
public interface RemoteShortUrlService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 转换内容
     */
    ShortUrlDto findById(Long id);

    /**
     * 保存
     *
     * @param dto 转换内容
     * @return 主键，为空说明新增失败
     */
    Long save(ShortUrlDto dto);

    /**
     * 根据主键更新
     *
     * @param dto 转换内容
     * @return 主键，为空说明新增失败
     */
    int update(ShortUrlDto dto);

    /**
     * 根据条件查询，不分页
     *
     * @param shortType 短链类型
     * @param pageQuery 分页查询
     * @return 转换内容
     */
    List<ShortUrlDto> selectPage(Integer shortType, PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param shortType 短链类型
     * @return 符合条件的记录数
     */
    Long selectCount(Integer shortType);
}
